/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.util;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum TrackBuilderMode implements StringRepresentable
{
    MODE_NOAIR(0, "noair", -1, -1),
    MODE_3X3(1, "3x3", 1, 3),
    MODE_5X5(2, "5x5", 2, 5),
    MODE_TUNNEL(3, "tunnel", -1, -1);

    public static final Codec<TrackBuilderMode> CODEC;
    public static final StreamCodec<ByteBuf, TrackBuilderMode> STREAM_CODEC;
    private final int id;
    private final String name;
    private final int distanceSide;
    private final int distanceUp;
    private final Component displayComponent;

    private TrackBuilderMode(int id, String name, int distanceSide, int distanceUp) {
        this.id = id;
        this.name = name;
        this.distanceSide = distanceSide;
        this.distanceUp = distanceUp;
        this.displayComponent = Component.translatable((String)("container.usefulrailroads.track_builder.mode." + name));
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public int getDistanceSide() {
        return this.distanceSide;
    }

    public int getDistanceUp() {
        return this.distanceUp;
    }

    public boolean isFullTunnel() {
        return this == MODE_TUNNEL;
    }

    public boolean isNoTunnel() {
        return this == MODE_NOAIR;
    }

    public Component getDisplayComponent() {
        return this.displayComponent;
    }

    public static TrackBuilderMode cycle(TrackBuilderMode mode) {
        switch (mode.ordinal()) {
            case 0: {
                return MODE_3X3;
            }
            case 1: {
                return MODE_5X5;
            }
            case 2: {
                return MODE_TUNNEL;
            }
            case 3: {
                return MODE_NOAIR;
            }
        }
        return mode;
    }

    static {
        CODEC = StringRepresentable.fromEnum(TrackBuilderMode::values);
        STREAM_CODEC = ByteBufCodecs.idMapper((IntFunction)ByIdMap.continuous(TrackBuilderMode::getId, (Object[])TrackBuilderMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO), TrackBuilderMode::getId);
    }
}

