/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.util;

import com.google.common.base.Predicates;
import info.u_team.useful_railroads.inventory.BlockTagItemContainer;
import info.u_team.useful_railroads.inventory.TrackBuilderInventoryWrapper;
import info.u_team.useful_railroads.util.ItemHandlerUtil;
import info.u_team.useful_railroads.util.TrackBuilderMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public abstract class TrackBuilderManager {
    protected final Level level;
    protected final Direction direction;
    protected final BlockPos startPos;
    protected final TrackBuilderMode mode;
    protected final Set<BlockPos> allPositionSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> firstRailPos = new HashSet<BlockPos>();
    protected final Set<BlockPos> railSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> groundSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> redstoneTorchSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> cobbleSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> airSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> tunnelSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> torchSet = new HashSet<BlockPos>();

    private TrackBuilderManager(BlockPos rayTracePos, Direction rayTraceFace, Level level, Vec3 lookVector, TrackBuilderMode mode) {
        this.level = level;
        this.direction = Direction.getNearest((double)lookVector.x, (double)lookVector.y, (double)lookVector.z);
        if (rayTraceFace.getAxis().isHorizontal()) {
            rayTracePos = rayTracePos.relative(this.direction.getOpposite());
        }
        if (!level.getBlockState(rayTracePos).canOcclude()) {
            rayTracePos = rayTracePos.below();
        }
        this.startPos = rayTracePos.immutable();
        this.mode = mode;
    }

    public void calculateBlockPosition() {
        Direction directionLeft = this.direction.getCounterClockWise();
        Direction directionRight = this.direction.getClockWise();
        this.calculate(directionLeft, directionRight);
        Stream.of(this.railSet, this.groundSet, this.tunnelSet, this.redstoneTorchSet, this.torchSet, this.cobbleSet, this.airSet).flatMap(Collection::stream).forEach(this.allPositionSet::add);
    }

    protected abstract void calculate(Direction var1, Direction var2);

    public void execute(Player player, TrackBuilderInventoryWrapper wrapper) {
        if (this.level.isClientSide || !(this.level instanceof ServerLevel)) {
            return;
        }
        int cost = this.calculateCost();
        if (wrapper.getFuel() < cost) {
            player.sendSystemMessage((Component)Component.translatable((String)"item.usefulrailroads.track_builder.not_enough_fuel", (Object[])new Object[]{cost}).withStyle(ChatFormatting.RED));
            return;
        }
        if (!(this.hasEnoughItems(wrapper.getRailInventory(), this.railSet) && this.hasEnoughItems(wrapper.getGroundInventory(), this.groundSet) && this.hasEnoughItems(wrapper.getTunnelInventory(), this.tunnelSet) && this.hasEnoughItems(wrapper.getRedstoneTorchInventory(), this.redstoneTorchSet) && this.hasEnoughItems(wrapper.getTorchInventory(), this.torchSet))) {
            player.sendSystemMessage((Component)Component.translatable((String)"item.usefulrailroads.track_builder.not_enough_blocks").withStyle(ChatFormatting.RED));
            return;
        }
        wrapper.setFuel(wrapper.getFuel() - cost);
        List<ItemStack> railStacks = this.extractItems(wrapper.getRailInventory(), this.railSet);
        List<ItemStack> groundStacks = this.extractItems(wrapper.getGroundInventory(), this.groundSet);
        List<ItemStack> tunnelStacks = this.extractItems(wrapper.getTunnelInventory(), this.tunnelSet);
        List<ItemStack> redstoneTorchStacks = this.extractItems(wrapper.getRedstoneTorchInventory(), this.redstoneTorchSet);
        List<ItemStack> torchStacks = this.extractItems(wrapper.getTorchInventory(), this.torchSet);
        SimpleContainer dropInventory = new SimpleContainer(50);
        this.allPositionSet.stream().filter(Predicates.not(arg_0 -> ((Level)this.level).isEmptyBlock(arg_0))).forEach(pos -> this.destroyBlock(player, (BlockPos)pos, dropInventory));
        Containers.dropContents((Level)this.level, (Entity)player, (Container)dropInventory);
        this.cobbleSet.forEach(pos -> this.placeBlock((BlockPos)pos, Blocks.COBBLESTONE.defaultBlockState()));
        this.redstoneTorchSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(redstoneTorchStacks)));
        this.groundSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(groundStacks)));
        this.railSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(railStacks)));
        this.tunnelSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(tunnelStacks)));
        this.torchSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(torchStacks), (item, block) -> {
            boolean redstoneTorch;
            boolean bl = redstoneTorch = item == Items.REDSTONE_TORCH;
            if (redstoneTorch || item == Items.TORCH) {
                Block torchWall = redstoneTorch ? Blocks.REDSTONE_WALL_TORCH : Blocks.WALL_TORCH;
                Block torchGround = redstoneTorch ? Blocks.REDSTONE_TORCH : Blocks.TORCH;
                return Stream.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).map(direction -> (BlockState)torchWall.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction)).filter(state -> state.canSurvive((LevelReader)this.level, pos)).findAny().orElseGet(() -> ((Block)torchGround).defaultBlockState());
            }
            return block.defaultBlockState();
        }));
        wrapper.writeItemStack();
    }

    private void placeItemBlock(BlockPos pos, ItemStack stack) {
        this.placeItemBlock(pos, stack, (item, block) -> block.defaultBlockState());
    }

    private void placeItemBlock(BlockPos pos, ItemStack stack, BiFunction<Item, Block, BlockState> function) {
        if (stack.isEmpty() && !(stack.getItem() instanceof BlockItem)) {
            return;
        }
        Block block = ((BlockItem)stack.getItem()).getBlock();
        this.placeBlock(pos, function.apply(stack.getItem(), block));
        BlockItem.updateCustomBlockEntityTag((Level)this.level, null, (BlockPos)pos, (ItemStack)stack);
    }

    private boolean placeBlock(BlockPos pos, BlockState state) {
        return this.placeBlock(pos, state, 3);
    }

    private boolean placeBlock(BlockPos pos, BlockState state, int flag) {
        return this.level.setBlock(pos, state, flag);
    }

    private void destroyBlock(Player player, BlockPos pos, SimpleContainer inventory) {
        BlockState state = this.level.getBlockState(pos);
        if (this.placeBlock(pos, Blocks.AIR.defaultBlockState()) && this.level instanceof ServerLevel) {
            Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)this.level), (BlockPos)pos, (BlockEntity)this.level.getBlockEntity(pos)).stream().map(arg_0 -> ((SimpleContainer)inventory).addItem(arg_0)).filter((Predicate<ItemStack>)Predicates.not(ItemStack::isEmpty)).forEach(stack -> Block.popResource((Level)this.level, (BlockPos)pos, (ItemStack)stack));
            state.spawnAfterBreak((ServerLevel)this.level, pos, ItemStack.EMPTY, true);
        }
    }

    private List<ItemStack> extractItems(BlockTagItemContainer handler, Set<BlockPos> set) {
        return ItemHandlerUtil.extractItems((Container)handler, handler::getCondition, set.size());
    }

    private boolean hasEnoughItems(BlockTagItemContainer handler, Set<BlockPos> set) {
        return ItemHandlerUtil.getItemCount((Container)handler, handler::getCondition) >= set.size();
    }

    private int calculateCost() {
        int breakCount = (int)this.allPositionSet.stream().filter(Predicates.not(arg_0 -> ((Level)this.level).isEmptyBlock(arg_0))).count();
        int placeCount = this.allPositionSet.size() - this.airSet.size();
        return breakCount * 2 + placeCount;
    }

    public Set<BlockPos> getAllPositionsSet() {
        return Collections.unmodifiableSet(this.allPositionSet);
    }

    public Set<BlockPos> getFirstRailPos() {
        return this.firstRailPos;
    }

    protected BlockPos addFirstRail(BlockPos pos) {
        this.firstRailPos.add(pos);
        return pos;
    }

    public static Optional<TrackBuilderManager> create(BlockPos rayTracePos, Direction rayTraceFace, Level level, Vec3 lookVector, TrackBuilderMode mode, boolean doubleTrack) {
        TrackBuilderManager manager;
        TrackBuilderManager trackBuilderManager = manager = doubleTrack ? new DoubleTrackBuilderManager(rayTracePos, rayTraceFace, level, lookVector, mode) : new SingleTrackBuilderManager(rayTracePos, rayTraceFace, level, lookVector, mode);
        if (manager.direction.getAxis().isHorizontal()) {
            manager.calculateBlockPosition();
            return Optional.of(manager);
        }
        return Optional.empty();
    }

    private static class DoubleTrackBuilderManager
    extends TrackBuilderManager {
        private DoubleTrackBuilderManager(BlockPos rayTracePos, Direction rayTraceFace, Level level, Vec3 lookVector, TrackBuilderMode mode) {
            super(rayTracePos, rayTraceFace, level, lookVector, mode);
        }

        @Override
        protected void calculate(Direction directionLeft, Direction directionRight) {
            BlockPos.betweenClosedStream((BlockPos)this.addFirstRail(this.startPos.relative(this.direction).relative(directionLeft).above()), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionLeft).above()).map(BlockPos::immutable).forEach(this.railSet::add);
            this.redstoneTorchSet.add(this.startPos.relative(this.direction, 9).relative(directionLeft).below().immutable());
            BlockPos.betweenClosedStream((BlockPos)this.addFirstRail(this.startPos.relative(this.direction).relative(directionRight).above()), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionRight).above()).map(BlockPos::immutable).forEach(this.railSet::add);
            this.redstoneTorchSet.add(this.startPos.relative(this.direction, 9).relative(directionRight).below().immutable());
            BlockPos.betweenClosedStream((BlockPos)this.startPos.relative(this.direction).relative(directionLeft, 2), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionRight, 2)).map(BlockPos::immutable).forEach(this.groundSet::add);
            BlockPos.betweenClosedStream((BlockPos)this.startPos.relative(this.direction).relative(directionLeft, 2).below(), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionRight, 2).below(2)).map(BlockPos::immutable).filter((Predicate<BlockPos>)Predicates.not(this.redstoneTorchSet::contains)).forEach(this.cobbleSet::add);
            if (this.mode.isFullTunnel()) {
                BlockPos.betweenClosedStream((BlockPos)this.startPos.relative(this.direction).relative(directionLeft, 2).above(), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionRight, 2).above(4)).map(BlockPos::immutable).forEach(this.airSet::add);
                BlockPos.betweenClosedStream((BlockPos)this.startPos.relative(this.direction).relative(directionLeft, 3).above(), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionRight, 3).above(5)).map(BlockPos::immutable).filter((Predicate<BlockPos>)Predicates.not(this.airSet::contains)).forEach(this.tunnelSet::add);
                this.torchSet.add(this.startPos.relative(this.direction, 3).above(3).relative(directionLeft, 2).immutable());
                this.torchSet.add(this.startPos.relative(this.direction, 7).above(3).relative(directionLeft, 2).immutable());
                this.torchSet.add(this.startPos.relative(this.direction, 11).above(3).relative(directionLeft, 2).immutable());
                this.torchSet.add(this.startPos.relative(this.direction, 15).above(3).relative(directionLeft, 2).immutable());
                this.torchSet.add(this.startPos.relative(this.direction, 3).above(3).relative(directionRight, 2).immutable());
                this.torchSet.add(this.startPos.relative(this.direction, 7).above(3).relative(directionRight, 2).immutable());
                this.torchSet.add(this.startPos.relative(this.direction, 11).above(3).relative(directionRight, 2).immutable());
                this.torchSet.add(this.startPos.relative(this.direction, 15).above(3).relative(directionRight, 2).immutable());
                this.airSet.removeAll(this.torchSet);
                this.airSet.removeAll(this.railSet);
            } else if (!this.mode.isNoTunnel()) {
                BlockPos.betweenClosedStream((BlockPos)this.startPos.relative(this.direction).relative(directionLeft, this.mode.getDistanceSide() + 1).above(), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionRight, this.mode.getDistanceSide() + 1).above(this.mode.getDistanceUp())).map(BlockPos::immutable).filter((Predicate<BlockPos>)Predicates.not(this.railSet::contains)).forEach(this.airSet::add);
            }
        }
    }

    private static class SingleTrackBuilderManager
    extends TrackBuilderManager {
        private SingleTrackBuilderManager(BlockPos rayTracePos, Direction rayTraceFace, Level level, Vec3 lookVector, TrackBuilderMode mode) {
            super(rayTracePos, rayTraceFace, level, lookVector, mode);
        }

        @Override
        protected void calculate(Direction directionLeft, Direction directionRight) {
            BlockPos.betweenClosedStream((BlockPos)this.addFirstRail(this.startPos.relative(this.direction).above()), (BlockPos)this.startPos.relative(this.direction, 17).above()).map(BlockPos::immutable).forEach(this.railSet::add);
            this.redstoneTorchSet.add(this.startPos.relative(this.direction, 9).below().immutable());
            BlockPos.betweenClosedStream((BlockPos)this.startPos.relative(this.direction).relative(directionLeft), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionRight)).map(BlockPos::immutable).forEach(this.groundSet::add);
            BlockPos.betweenClosedStream((BlockPos)this.startPos.relative(this.direction).relative(directionLeft).below(), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionRight).below(2)).map(BlockPos::immutable).filter((Predicate<BlockPos>)Predicates.not(this.redstoneTorchSet::contains)).forEach(this.cobbleSet::add);
            if (this.mode.isFullTunnel()) {
                BlockPos.betweenClosedStream((BlockPos)this.startPos.relative(this.direction).relative(directionLeft, 1).above(), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionRight, 1).above(4)).map(BlockPos::immutable).forEach(this.airSet::add);
                BlockPos.betweenClosedStream((BlockPos)this.startPos.relative(this.direction).relative(directionLeft, 2).above(), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionRight, 2).above(5)).map(BlockPos::immutable).filter((Predicate<BlockPos>)Predicates.not(this.airSet::contains)).forEach(this.tunnelSet::add);
                this.torchSet.add(this.startPos.relative(this.direction, 5).above(3).relative(directionLeft, 1).immutable());
                this.torchSet.add(this.startPos.relative(this.direction, 13).above(3).relative(directionLeft, 1).immutable());
                this.torchSet.add(this.startPos.relative(this.direction, 5).above(3).relative(directionRight, 1).immutable());
                this.torchSet.add(this.startPos.relative(this.direction, 13).above(3).relative(directionRight, 1).immutable());
                this.airSet.removeAll(this.torchSet);
                this.airSet.removeAll(this.railSet);
            } else if (!this.mode.isNoTunnel()) {
                BlockPos.betweenClosedStream((BlockPos)this.startPos.relative(this.direction).relative(directionLeft, this.mode.getDistanceSide()).above(), (BlockPos)this.startPos.relative(this.direction, 17).relative(directionRight, this.mode.getDistanceSide()).above(this.mode.getDistanceUp())).map(BlockPos::immutable).filter((Predicate<BlockPos>)Predicates.not(this.railSet::contains)).forEach(this.airSet::add);
            }
        }
    }
}

