/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class Location {
    private ResourceKey<Level> resourceKey;
    private BlockPos pos;

    public static Location getOrigin() {
        return new Location((ResourceKey<Level>)Level.OVERWORLD, BlockPos.ZERO);
    }

    public Location(ResourceKey<Level> dimensionType, BlockPos pos) {
        this.resourceKey = dimensionType;
        this.pos = pos;
    }

    public ResourceKey<Level> getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(ResourceKey<Level> dimensionType) {
        this.resourceKey = dimensionType;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public void serialize(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.resourceKey.location());
        buffer.writeBlockPos(this.pos);
    }

    public void deserialize(FriendlyByteBuf buffer) {
        this.resourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buffer.readResourceLocation());
        if (this.resourceKey == null) {
            this.resourceKey = Level.OVERWORLD;
        }
        this.pos = buffer.readBlockPos();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putString("dimension", this.resourceKey.location().toString());
        compound.putInt("x", this.pos.getX());
        compound.putInt("y", this.pos.getY());
        compound.putInt("z", this.pos.getZ());
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        ResourceLocation dimensionLocation = ResourceLocation.tryParse((String)compound.getString("dimension"));
        if (dimensionLocation != null) {
            this.resourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionLocation);
        }
        if (this.resourceKey == null) {
            this.resourceKey = Level.OVERWORLD;
        }
        this.pos = new BlockPos(compound.getInt("x"), compound.getInt("y"), compound.getInt("z"));
    }
}

