/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.screen;

import info.u_team.u_team_core.screen.UContainerMenuScreen;
import info.u_team.useful_railroads.blockentity.TeleportRailBlockEntity;
import info.u_team.useful_railroads.menu.TeleportRailMenu;
import info.u_team.useful_railroads.util.Location;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TeleportRailScreen
extends UContainerMenuScreen<TeleportRailMenu> {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"usefulrailroads", (String)"textures/gui/teleport_rail.png");
    private final Component dimensionTextComponent;
    private final Component xTextComponent;
    private final Component yTextComponent;
    private final Component zTextComponent;
    private final Component fuelTextComponent;
    private final Component consumptionTextComponent;
    private final Component seperatorTextComponent;

    public TeleportRailScreen(TeleportRailMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title, BACKGROUND, 176, 189);
        String langKey = "container.usefulrailroads.teleport_rail.";
        this.dimensionTextComponent = Component.translatable((String)"container.usefulrailroads.teleport_rail.dimension");
        this.xTextComponent = Component.translatable((String)"container.usefulrailroads.teleport_rail.x");
        this.yTextComponent = Component.translatable((String)"container.usefulrailroads.teleport_rail.y");
        this.zTextComponent = Component.translatable((String)"container.usefulrailroads.teleport_rail.z");
        this.fuelTextComponent = Component.translatable((String)"container.usefulrailroads.teleport_rail.fuel");
        this.consumptionTextComponent = Component.translatable((String)"container.usefulrailroads.teleport_rail.consumption");
        this.seperatorTextComponent = Component.literal((String)": ");
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        TeleportRailBlockEntity tileEntity = (TeleportRailBlockEntity)((TeleportRailMenu)this.getMenu()).getBlockEntity();
        Location location = tileEntity.getLocation();
        BlockPos pos = location.getPos();
        guiGraphics.drawString(this.font, (Component)this.dimensionTextComponent.plainCopy().append(this.seperatorTextComponent).append((Component)Component.literal((String)location.getResourceKey().location().toString()).withStyle(ChatFormatting.DARK_GREEN)), 11, 23, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)this.xTextComponent.plainCopy().append(this.seperatorTextComponent).append((Component)Component.literal((String)Integer.toString(pos.getX())).withStyle(ChatFormatting.DARK_GREEN)), 11, 33, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)this.yTextComponent.plainCopy().append(this.seperatorTextComponent).append((Component)Component.literal((String)Integer.toString(pos.getY())).withStyle(ChatFormatting.DARK_GREEN)), 11, 43, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)this.zTextComponent.plainCopy().append(this.seperatorTextComponent).append((Component)Component.literal((String)Integer.toString(pos.getZ())).withStyle(ChatFormatting.DARK_GREEN)), 11, 53, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)this.fuelTextComponent.plainCopy().append(this.seperatorTextComponent).append((Component)Component.literal((String)Integer.toString(tileEntity.getFuel())).withStyle(ChatFormatting.DARK_AQUA)), 11, 68, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)this.consumptionTextComponent.plainCopy().append(this.seperatorTextComponent).append((Component)Component.literal((String)Integer.toString(tileEntity.getCost())).withStyle(ChatFormatting.DARK_RED)), 11, 78, 0x404040, false);
    }
}

