/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.menu;

import info.u_team.u_team_core.api.sync.DataHolder;
import info.u_team.u_team_core.api.sync.MessageHolder;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_railroads.init.UsefulRailroadsMenuTypes;
import info.u_team.useful_railroads.inventory.FuelItemSlot;
import info.u_team.useful_railroads.inventory.RestrictedSlot;
import info.u_team.useful_railroads.inventory.TrackBuilderInventoryWrapper;
import info.u_team.useful_railroads.item.TrackBuilderItem;
import info.u_team.useful_railroads.util.TrackBuilderMode;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TrackBuilderMenu
extends UContainerMenu {
    private final TrackBuilderInventoryWrapper wrapper;
    private final MessageHolder.EmptyMessageHolder changeModeMessage;
    private final int selectedSlot;

    public TrackBuilderMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(containerId, playerInventory, new TrackBuilderInventoryWrapper.Client(buffer.readVarInt(), (TrackBuilderMode)buffer.readEnum(TrackBuilderMode.class), () -> ((Player)playerInventory.player).level()), buffer.readVarInt());
    }

    public TrackBuilderMenu(int containerId, Inventory playerInventory, TrackBuilderInventoryWrapper wrapper, int selectedSlot) {
        super((MenuType)UsefulRailroadsMenuTypes.TRACK_BUILDER.get(), containerId);
        this.wrapper = wrapper;
        this.selectedSlot = selectedSlot;
        this.addSlots((index, x, y) -> new FuelItemSlot(wrapper.getFuelInventory(), index, x, y), 1, 1, 260, 182);
        this.addSlots((index, x, y) -> new RestrictedSlot((Container)wrapper.getRailInventory(), index, x, y), 1, 15, 8, 32);
        this.addSlots((index, x, y) -> new RestrictedSlot((Container)wrapper.getGroundInventory(), index, x, y), 2, 15, 8, 64);
        this.addSlots((index, x, y) -> new RestrictedSlot((Container)wrapper.getTunnelInventory(), index, x, y), 3, 15, 8, 114);
        this.addSlots((index, x, y) -> new RestrictedSlot((Container)wrapper.getRedstoneTorchInventory(), index, x, y), 1, 5, 8, 182);
        this.addSlots((index, x, y) -> new RestrictedSlot((Container)wrapper.getTorchInventory(), index, x, y), 1, 4, 116, 182);
        this.addPlayerInventory(playerInventory, 62, 214);
        this.addDataHolderToClient(DataHolder.createIntHolder(wrapper::getFuel, wrapper::setFuel));
        this.addDataHolderToClient(DataHolder.createByteHolder(() -> (byte)wrapper.getMode().ordinal(), value -> wrapper.setMode(((TrackBuilderMode[])TrackBuilderMode.class.getEnumConstants())[value])));
        this.changeModeMessage = (MessageHolder.EmptyMessageHolder)this.addDataHolderToServer((DataHolder)new MessageHolder.EmptyMessageHolder(() -> {
            wrapper.setMode(TrackBuilderMode.cycle(wrapper.getMode()));
            wrapper.writeItemStack();
        }));
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.wrapper.writeItemStack();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack remainingStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            remainingStack = stack.copy();
            if (index < 97 ? !this.moveItemStackTo(stack, 97, this.slots.size(), true) : (index >= 124 ? !this.moveItemStackTo(stack, 0, 124, false) : !this.moveItemStackTo(stack, 0, 97, false) && !this.moveItemStackTo(stack, 124, 133, false))) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return remainingStack;
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        Slot tmpSlot = slotId >= 0 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
        if (tmpSlot != null && tmpSlot.container == player.getInventory() && tmpSlot.getContainerSlot() == this.selectedSlot) {
            return;
        }
        if (clickType == ClickType.SWAP) {
            ItemStack currentItem;
            ItemStack stack = player.getInventory().getItem(dragType);
            ItemStack itemStack = Inventory.isHotbarSlot((int)this.selectedSlot) ? (ItemStack)player.getInventory().items.get(this.selectedSlot) : (currentItem = this.selectedSlot == -1 ? (ItemStack)player.getInventory().offhand.get(0) : ItemStack.EMPTY);
            if (!currentItem.isEmpty() && stack == currentItem) {
                return;
            }
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public boolean stillValid(Player player) {
        if (this.wrapper instanceof TrackBuilderInventoryWrapper.Server) {
            ItemStack stack = ((TrackBuilderInventoryWrapper.Server)this.wrapper).getStack();
            return !stack.isEmpty() && stack.getItem() instanceof TrackBuilderItem;
        }
        return true;
    }

    public TrackBuilderInventoryWrapper getWrapper() {
        return this.wrapper;
    }

    public MessageHolder.EmptyMessageHolder getChangeModeMessage() {
        return this.changeModeMessage;
    }
}

