/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.item;

import info.u_team.u_team_core.item.UItem;
import info.u_team.u_team_core.util.MenuUtil;
import info.u_team.u_team_core.util.TooltipCreator;
import info.u_team.useful_railroads.component.TrackBuilderComponent;
import info.u_team.useful_railroads.init.UsefulRailroadsDataComponentTypes;
import info.u_team.useful_railroads.inventory.TrackBuilderInventoryWrapper;
import info.u_team.useful_railroads.menu.TrackBuilderMenu;
import info.u_team.useful_railroads.util.TrackBuilderManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class TrackBuilderItem
extends UItem {
    private final boolean doubleTrack;

    public TrackBuilderItem(boolean doubleTrack) {
        super(new Item.Properties().stacksTo(1).rarity(doubleTrack ? Rarity.EPIC : Rarity.RARE).component((DataComponentType)UsefulRailroadsDataComponentTypes.TRACK_BUILDER.get(), (Object)TrackBuilderComponent.EMPTY));
        this.doubleTrack = doubleTrack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && !player.isShiftKeyDown() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TrackBuilderInventoryWrapper.Server wrapper = new TrackBuilderInventoryWrapper.Server(stack, () -> ((Player)player).level());
            int selectedSlot = hand == InteractionHand.MAIN_HAND ? player.getInventory().selected : -1;
            MenuUtil.openMenu((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, playerInventory, openPlayer) -> new TrackBuilderMenu(id, playerInventory, wrapper, selectedSlot), (Component)Component.translatable((String)"container.usefulrailroads.track_builder")), buffer -> {
                buffer.writeVarInt(wrapper.getFuel());
                buffer.writeEnum((Enum)wrapper.getMode());
                buffer.writeVarInt(selectedSlot);
            }, (boolean)false);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        if (player == null || !context.isSecondaryUseActive() || context.getHand() == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        TrackBuilderInventoryWrapper.Server wrapper = new TrackBuilderInventoryWrapper.Server(context.getItemInHand(), () -> ((Player)player).level());
        TrackBuilderManager.create(context.getClickedPos(), context.getClickedFace(), level, player.getLookAngle(), wrapper.getMode(), this.doubleTrack).ifPresent(manager -> manager.execute(player, wrapper));
        return InteractionResult.SUCCESS;
    }

    public boolean shouldPlayUpdateAnimation(ItemStack oldStack, ItemStack newStack) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean canBeDropped(ItemStack stack, Player player) {
        return !(player.containerMenu instanceof TrackBuilderMenu);
    }

    public boolean isDoubleTrack() {
        return this.doubleTrack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)TooltipCreator.create((Item)this, (String)"", (int)0, (Object[])new Object[]{TooltipCreator.create((String)"usefulrailroads", (String)"click", (String)"right_click", (int)0).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD})}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)TooltipCreator.create((Item)this, (String)"", (int)1, (Object[])new Object[]{TooltipCreator.create((String)"usefulrailroads", (String)"click", (String)"shift_right_click", (int)0).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD})}).withStyle(ChatFormatting.GRAY));
    }
}

