/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.inventory;

import info.u_team.useful_railroads.component.TrackBuilderComponent;
import info.u_team.useful_railroads.init.UsefulRailroadsDataComponentTypes;
import info.u_team.useful_railroads.init.UsefulRailroadsRecipeTypes;
import info.u_team.useful_railroads.init.UsefulRailroadsTags;
import info.u_team.useful_railroads.inventory.BlockTagItemContainer;
import info.u_team.useful_railroads.inventory.FuelItemContainer;
import info.u_team.useful_railroads.recipe.TrackBuilderFuelRecipe;
import info.u_team.useful_railroads.util.TrackBuilderMode;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class TrackBuilderInventoryWrapper {
    protected final BlockTagItemContainer railInventory = new BlockTagItemContainer(UsefulRailroadsTags.Items.TRACK_BUILDER_RAILS, 15);
    protected final BlockTagItemContainer groundInventory = new BlockTagItemContainer(UsefulRailroadsTags.Items.TRACK_BUILDER_GROUND_BLOCKS, 30);
    protected final BlockTagItemContainer tunnelInventory = new BlockTagItemContainer(UsefulRailroadsTags.Items.TRACK_BUILDER_TUNNEL_BLOCKS, 45);
    protected final BlockTagItemContainer redstoneTorchInventory = new BlockTagItemContainer(UsefulRailroadsTags.Items.TRACK_BUILDER_REDSTONE_TORCHES, 5);
    protected final BlockTagItemContainer torchInventory = new BlockTagItemContainer(UsefulRailroadsTags.Items.TRACK_BUILDER_TORCHES, 4);
    protected final FuelItemContainer<TrackBuilderFuelRecipe> fuelInventory;
    protected int fuel = 0;
    protected TrackBuilderMode mode = TrackBuilderMode.MODE_NOAIR;

    private TrackBuilderInventoryWrapper(Supplier<Level> levelSupplier) {
        this.fuelInventory = new FuelItemContainer((RecipeType)UsefulRailroadsRecipeTypes.TRACK_BUILDER_FUEL.get(), levelSupplier, fuelAdder -> this.fuel += fuelAdder);
    }

    public BlockTagItemContainer getRailInventory() {
        return this.railInventory;
    }

    public BlockTagItemContainer getGroundInventory() {
        return this.groundInventory;
    }

    public BlockTagItemContainer getTunnelInventory() {
        return this.tunnelInventory;
    }

    public BlockTagItemContainer getRedstoneTorchInventory() {
        return this.redstoneTorchInventory;
    }

    public BlockTagItemContainer getTorchInventory() {
        return this.torchInventory;
    }

    public Container getFuelInventory() {
        return this.fuelInventory;
    }

    public void readItemStack() {
    }

    public void writeItemStack() {
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public TrackBuilderMode getMode() {
        return this.mode;
    }

    public void setMode(TrackBuilderMode mode) {
        this.mode = mode;
    }

    public static class Server
    extends TrackBuilderInventoryWrapper {
        private final ItemStack stack;

        public Server(ItemStack stack, Supplier<Level> levelSupplier) {
            super(levelSupplier);
            this.stack = stack;
            this.readItemStack();
        }

        @Override
        public void readItemStack() {
            TrackBuilderComponent component = (TrackBuilderComponent)this.stack.get((DataComponentType)UsefulRailroadsDataComponentTypes.TRACK_BUILDER.get());
            if (component != null) {
                component.getRails().copyInto(this.railInventory.getItems());
                component.getGroundBlocks().copyInto(this.groundInventory.getItems());
                component.getTunnelBlocks().copyInto(this.tunnelInventory.getItems());
                component.getRedstoneTorches().copyInto(this.redstoneTorchInventory.getItems());
                component.getTorches().copyInto(this.torchInventory.getItems());
                this.fuel = component.getFuel();
                this.mode = component.getMode();
            }
        }

        @Override
        public void writeItemStack() {
            TrackBuilderComponent component = TrackBuilderComponent.of((List<ItemStack>)this.railInventory.getItems(), (List<ItemStack>)this.groundInventory.getItems(), (List<ItemStack>)this.tunnelInventory.getItems(), (List<ItemStack>)this.redstoneTorchInventory.getItems(), (List<ItemStack>)this.torchInventory.getItems(), this.fuel, this.mode);
            this.stack.set((DataComponentType)UsefulRailroadsDataComponentTypes.TRACK_BUILDER.get(), (Object)component);
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }

    public static class Client
    extends TrackBuilderInventoryWrapper {
        public Client(int fuel, TrackBuilderMode mode, Supplier<Level> levelSupplier) {
            super(levelSupplier);
            this.fuel = fuel;
            this.mode = mode;
        }
    }
}

