/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.inventory;

import info.u_team.useful_railroads.recipe.FuelRecipe;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class FuelItemContainer<T extends FuelRecipe>
implements Container {
    private final RecipeType<T> recipeType;
    private final Supplier<Level> levelSupplier;
    private final BooleanSupplier canAddFuel;
    private final IntConsumer fuelAdder;
    private T currentRecipe;
    private ItemStack failedMatch = ItemStack.EMPTY;

    public FuelItemContainer(RecipeType<T> recipeType, Supplier<Level> levelSupplier, IntConsumer fuelAdder) {
        this(recipeType, levelSupplier, () -> true, fuelAdder);
    }

    public FuelItemContainer(RecipeType<T> recipeType, Supplier<Level> levelSupplier, BooleanSupplier canAddFuel, IntConsumer fuelAdder) {
        this.recipeType = recipeType;
        this.levelSupplier = levelSupplier;
        this.canAddFuel = canAddFuel;
        this.fuelAdder = fuelAdder;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.canAddFuel.getAsBoolean() && this.getRecipe(stack, this.levelSupplier.get()).isPresent();
    }

    public void setItem(int slot, ItemStack stack) {
        Level world = this.levelSupplier.get();
        if (!world.isClientSide) {
            this.getRecipe(stack, world).ifPresent(recipe -> this.fuelAdder.accept(stack.getCount() * recipe.getFuel()));
        }
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.getMaxStackSize();
    }

    private Optional<T> getRecipe(ItemStack stack, Level world) {
        SingleRecipeInput input = new SingleRecipeInput(stack);
        if (stack.isEmpty() || stack == this.failedMatch) {
            return Optional.empty();
        }
        if (this.currentRecipe != null && ((FuelRecipe)this.currentRecipe).matches(input, world)) {
            return Optional.of(this.currentRecipe);
        }
        FuelRecipe recipe = world.getRecipeManager().getRecipeFor(this.recipeType, (RecipeInput)input, world).map(RecipeHolder::value).orElse(null);
        this.failedMatch = recipe == null ? stack : ItemStack.EMPTY;
        this.currentRecipe = recipe;
        return Optional.ofNullable(this.currentRecipe);
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return true;
    }

    public ItemStack getItem(int slot) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int amount) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ItemStack.EMPTY;
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        return false;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
    }

    public void setChanged() {
    }
}

