/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.config;

import info.u_team.u_team_core.util.ConfigValueHolder;
import info.u_team.useful_railroads.config.CommonConfig;
import java.util.function.Supplier;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoForgeCommonConfig {
    public static final ModConfigSpec CONFIG;
    private static final NeoForgeCommonConfig INSTANCE;
    public final ConfigValueHolder<Double> highspeedRailMaxSpeed;
    public final ConfigValueHolder<Double> highspeedRailAccelOccupied;
    public final ConfigValueHolder<Double> highspeedRailAccelUnoccupied;
    public final ConfigValueHolder<Double> speedClampRailSpeed;
    public final ConfigValueHolder<Integer> teleportRailLogDivisionCost;
    public final ConfigValueHolder<Integer> teleportRailDimensionCost;

    private NeoForgeCommonConfig(ModConfigSpec.Builder builder) {
        builder.comment("Rail Settings").push("rail");
        builder.comment("High Speed Rail Settings").push("highspeedrail");
        ModConfigSpec.DoubleValue highspeedRailMaxSpeedValue = builder.comment("Maximum Speed for High Speed Rail (default: 5.0 blocks/tick)").defineInRange("highSpeedRailMaxSpeed", 5.0, 0.0, 10.0);
        ModConfigSpec.DoubleValue highspeedRailAccelOccupiedValue = builder.comment("Acceleration for High Speed Rail if Occupied (default: 4.0 blocks/tick^2)").defineInRange("highSpeedRailAccelOccupied", 4.0, 0.0, 10.0);
        ModConfigSpec.DoubleValue highspeedRailAccelUnoccupiedValue = builder.comment("Acceleration for High Speed Rail if Unoccupied (default: 2.0 blocks/tick^2)").defineInRange("highSpeedRailAccelUnoccupied", 2.0, 0.0, 10.0);
        builder.pop();
        builder.comment("Speed Clamp Rail Settings").push("speedclamprail");
        ModConfigSpec.DoubleValue speedClampRailSpeedValue = builder.comment("Speed for Speed Clamp Rail (default: 0.25 blocks/tick)").defineInRange("speedClampRailSpeed", 0.25, 0.0, 10.0);
        builder.pop();
        builder.comment("Teleport Rail Settings").push("teleportrail");
        ModConfigSpec.IntValue teleportRailLogDivisionCostValue = builder.comment("Cost divided by natural log of this value. Lower values increase the cost").defineInRange("teleportRailLogDivisionCost", 5, 2, 100);
        ModConfigSpec.IntValue teleportRailDimensionCostValue = builder.comment("Extra cost per dimension teleport").defineInRange("teleportRailDimensionCost", 100, 0, 1000000);
        builder.pop();
        builder.pop();
        this.highspeedRailMaxSpeed = new ConfigValueHolder((Supplier)highspeedRailMaxSpeedValue, arg_0 -> ((ModConfigSpec.DoubleValue)highspeedRailMaxSpeedValue).set(arg_0));
        this.highspeedRailAccelOccupied = new ConfigValueHolder((Supplier)highspeedRailAccelOccupiedValue, arg_0 -> ((ModConfigSpec.DoubleValue)highspeedRailAccelOccupiedValue).set(arg_0));
        this.highspeedRailAccelUnoccupied = new ConfigValueHolder((Supplier)highspeedRailAccelUnoccupiedValue, arg_0 -> ((ModConfigSpec.DoubleValue)highspeedRailAccelUnoccupiedValue).set(arg_0));
        this.speedClampRailSpeed = new ConfigValueHolder((Supplier)speedClampRailSpeedValue, arg_0 -> ((ModConfigSpec.DoubleValue)speedClampRailSpeedValue).set(arg_0));
        this.teleportRailLogDivisionCost = new ConfigValueHolder((Supplier)teleportRailLogDivisionCostValue, arg_0 -> ((ModConfigSpec.IntValue)teleportRailLogDivisionCostValue).set(arg_0));
        this.teleportRailDimensionCost = new ConfigValueHolder((Supplier)teleportRailDimensionCostValue, arg_0 -> ((ModConfigSpec.IntValue)teleportRailDimensionCostValue).set(arg_0));
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(NeoForgeCommonConfig::new);
        CONFIG = (ModConfigSpec)pair.getRight();
        INSTANCE = (NeoForgeCommonConfig)pair.getLeft();
    }

    public static class Impl
    extends CommonConfig {
        @Override
        public ConfigValueHolder<Double> highspeedRailMaxSpeed() {
            return NeoForgeCommonConfig.INSTANCE.highspeedRailMaxSpeed;
        }

        @Override
        public ConfigValueHolder<Double> highspeedRailAccelOccupied() {
            return NeoForgeCommonConfig.INSTANCE.highspeedRailAccelOccupied;
        }

        @Override
        public ConfigValueHolder<Double> highspeedRailAccelUnoccupied() {
            return NeoForgeCommonConfig.INSTANCE.highspeedRailAccelUnoccupied;
        }

        @Override
        public ConfigValueHolder<Double> speedClampRailSpeed() {
            return NeoForgeCommonConfig.INSTANCE.speedClampRailSpeed;
        }

        @Override
        public ConfigValueHolder<Integer> teleportRailLogDivisionCost() {
            return NeoForgeCommonConfig.INSTANCE.teleportRailLogDivisionCost;
        }

        @Override
        public ConfigValueHolder<Integer> teleportRailDimensionCost() {
            return NeoForgeCommonConfig.INSTANCE.teleportRailDimensionCost;
        }
    }
}

