/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.blockentity;

import info.u_team.u_team_core.api.block.MenuSyncedBlockEntity;
import info.u_team.u_team_core.api.menu.ItemSlotCreator;
import info.u_team.u_team_core.blockentity.UBlockEntity;
import info.u_team.u_team_core.util.LevelUtil;
import info.u_team.u_team_core.util.ServiceUtil;
import info.u_team.useful_railroads.config.CommonConfig;
import info.u_team.useful_railroads.init.UsefulRailroadsBlockEntityTypes;
import info.u_team.useful_railroads.init.UsefulRailroadsRecipeTypes;
import info.u_team.useful_railroads.inventory.FuelItemContainer;
import info.u_team.useful_railroads.inventory.FuelItemSlot;
import info.u_team.useful_railroads.menu.TeleportRailMenu;
import info.u_team.useful_railroads.recipe.TeleportRailFuelRecipe;
import info.u_team.useful_railroads.util.Location;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TeleportRailBlockEntity
extends UBlockEntity
implements MenuSyncedBlockEntity {
    private final Location location = Location.getOrigin();
    private int fuel;
    private int cost;
    private final FuelItemContainer<TeleportRailFuelRecipe> fuelSlot = new FuelItemContainer((RecipeType)UsefulRailroadsRecipeTypes.TELEPORT_RAIL_FUEL.get(), () -> ((TeleportRailBlockEntity)this).getLevel(), () -> this.fuel < 10000, fuelAdder -> {
        this.fuel += fuelAdder;
        this.setChanged();
    });

    protected TeleportRailBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)UsefulRailroadsBlockEntityTypes.TELEPORT_RAIL.get(), pos, state);
    }

    private void checkCost() {
        if (this.cost == 0) {
            this.cost = this.calculateCost();
        }
    }

    private int calculateCost() {
        int calculatedCost = 0;
        if (!this.location.getResourceKey().equals((Object)this.level.dimension())) {
            calculatedCost += ((Integer)CommonConfig.getInstance().teleportRailDimensionCost().get()).intValue();
        }
        double calculatedDistance = Math.log(this.worldPosition.distSqr((Vec3i)this.location.getPos())) / Math.log(((Integer)CommonConfig.getInstance().teleportRailLogDivisionCost().get()).intValue());
        if ((calculatedCost += Mth.floor((double)(calculatedDistance *= calculatedDistance))) == 0) {
            return 1;
        }
        return calculatedCost;
    }

    public void teleport(BlockPos pos, AbstractMinecart cart) {
        this.checkCost();
        cart.setDeltaMovement(0.0, 0.0, 0.0);
        Entity entity = cart.getFirstPassenger();
        if (this.fuel < this.cost) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.displayClientMessage((Component)Component.translatable((String)"block.usefulrailroads.teleport_rail.not_enough_fuel", (Object[])new Object[]{this.cost}).withStyle(ChatFormatting.RED), true);
            }
            return;
        }
        this.fuel -= this.cost;
        this.setChanged();
        ServerLevel teleportLevel = cart.getServer().getLevel(this.location.getResourceKey());
        if (teleportLevel == null) {
            return;
        }
        cart.getServer().tell((Runnable)new TickTask(0, () -> {
            Vec3 teleportPos = Vec3.atCenterOf((Vec3i)this.location.getPos());
            Entity newEntity = entity != null ? LevelUtil.teleportEntity((Entity)entity, (ServerLevel)teleportLevel, (Vec3)teleportPos) : null;
            Entity newCart = LevelUtil.teleportEntity((Entity)cart, (ServerLevel)teleportLevel, (Vec3)teleportPos);
            if (newEntity != null) {
                newEntity.startRiding(newCart, true);
                teleportLevel.getChunkSource().broadcastAndSend(newEntity, (Packet)new ClientboundSetPassengersPacket(newCart));
            }
        }));
    }

    public void saveNBT(CompoundTag compound, HolderLookup.Provider registries) {
        compound.put("location", (Tag)this.location.serializeNBT());
        if (this.fuel != 0) {
            compound.putInt("fuel", this.fuel);
        }
    }

    public void loadNBT(CompoundTag compound, HolderLookup.Provider registries) {
        this.location.deserializeNBT(compound.getCompound("location"));
        this.fuel = compound.getInt("fuel");
    }

    public void sendInitialMenuDataToClient(FriendlyByteBuf buffer) {
        this.checkCost();
        this.location.serialize(buffer);
        buffer.writeInt(this.fuel);
        buffer.writeInt(this.cost);
    }

    public void handleInitialMenuDataFromServer(FriendlyByteBuf buffer) {
        this.location.deserialize(buffer);
        this.fuel = buffer.readInt();
        this.cost = buffer.readInt();
    }

    public FuelItemContainer<TeleportRailFuelRecipe> getFuelSlot() {
        return this.fuelSlot;
    }

    public ItemSlotCreator getSlotCreator() {
        return (index, x, y) -> new FuelItemSlot(this.fuelSlot, index, x, y);
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new TeleportRailMenu(containerId, playerInventory, this);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.usefulrailroads.teleport_rail");
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getCost() {
        return this.cost;
    }

    public static interface Factory {
        public static final Factory INSTANCE = (Factory)ServiceUtil.loadOne(Factory.class);

        public TeleportRailBlockEntity create(BlockPos var1, BlockState var2);
    }
}

