/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import com.mojang.serialization.MapCodec;
import info.u_team.useful_railroads.block.CustomAdvancedBlockEntityRailBlock;
import info.u_team.useful_railroads.blockentity.BufferStopBlockEntity;
import info.u_team.useful_railroads.init.UsefulRailroadsBlockEntityTypes;
import info.u_team.useful_railroads.util.ItemHandlerUtil;
import info.u_team.useful_railroads.util.VoxelShapeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class BufferStopBlock
extends CustomAdvancedBlockEntityRailBlock {
    public static final MapCodec<BufferStopBlock> CODEC = BufferStopBlock.simpleCodec(__ -> new BufferStopBlock());
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final Map<Direction, VoxelShape> VOXEL_SHAPES = BufferStopBlock.createVoxelShape();

    private static List<Pair<Vec3, Vec3>> createSideShapeVec(int bracketStart, int bracketEnd, int supportStart, int supportEnd, int stopperStart, int stopperEnd) {
        ArrayList<Pair<Vec3, Vec3>> list = new ArrayList<Pair<Vec3, Vec3>>();
        for (int i = 0; i < 10; ++i) {
            list.add(VoxelShapeUtil.createVectorPair(bracketStart, 2 + i, 14 - i, bracketEnd, 3 + i, 16 - i));
        }
        list.add(VoxelShapeUtil.createVectorPair(stopperStart, 11.0, 0.0, stopperEnd, 16.0, 1.0));
        list.add(VoxelShapeUtil.createVectorPair(supportStart, 2.0, 2.0, supportEnd, 14.0, 6.0));
        return list;
    }

    private static Map<Direction, VoxelShape> createVoxelShape() {
        ArrayList<Pair<Vec3, Vec3>> northShape = new ArrayList<Pair<Vec3, Vec3>>();
        northShape.addAll(BufferStopBlock.createSideShapeVec(2, 3, 2, 4, 0, 5));
        northShape.addAll(BufferStopBlock.createSideShapeVec(13, 14, 12, 14, 11, 16));
        northShape.add(VoxelShapeUtil.createVectorPair(0.0, 12.0, 1.0, 16.0, 15.0, 3.0));
        return VoxelShapeUtil.getHorizontalRotations(northShape).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, valueEntry -> Shapes.or((VoxelShape)FLAT_AABB, (VoxelShape[])((VoxelShape[])VoxelShapeUtil.createVoxelShapeFromVector((List)valueEntry.getValue()).stream().toArray(VoxelShape[]::new)))));
    }

    public BufferStopBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).noCollission().strength(1.5f).sound(SoundType.METAL), (Supplier<? extends BlockEntityType<?>>)UsefulRailroadsBlockEntityTypes.BUFFER_STOP);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return VOXEL_SHAPES.getOrDefault(state.getValue((Property)FACING), VOXEL_SHAPES.get(Direction.NORTH));
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        cart.setDeltaMovement(0.0, 0.0, 0.0);
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        if (!powered) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            Vec3 vec = cart.position().add((double)direction.getStepX() * 1.1, 0.0, (double)direction.getStepZ() * 1.1);
            cart.moveTo(vec.x(), vec.y(), vec.z(), cart.getYRot(), cart.getXRot());
        }
        if (level.isClientSide || !powered) {
            return;
        }
        Optional tileEntityOptional = this.getBlockEntity((BlockGetter)level, pos);
        tileEntityOptional.ifPresent(bufferStop -> {
            cart.ejectPassengers();
            ArrayList drops = new ArrayList();
            cart.captureDrops(drops);
            cart.destroy(cart.damageSources().magic());
            drops.stream().map(ItemEntity::getItem).forEach(stack -> {
                ItemStack stackLeft = bufferStop.getMinecartSlots().addItem(stack);
                if (!stackLeft.isEmpty()) {
                    BufferStopBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stackLeft);
                }
                bufferStop.setChanged();
            });
        });
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).getEntity()) instanceof AbstractMinecart) {
            Direction.AxisDirection axisDirection;
            AbstractMinecart cart = (AbstractMinecart)entity;
            Vec3 motion = cart.getDeltaMovement();
            Direction oppositeDirection = ((Direction)state.getValue((Property)FACING)).getOpposite();
            Direction.Axis axis = oppositeDirection.getAxis();
            if (this.isRightCollision(axis, Direction.Axis.X, axisDirection = oppositeDirection.getAxisDirection(), motion.x()) || this.isRightCollision(axis, Direction.Axis.Z, axisDirection, motion.z())) {
                return Shapes.empty();
            }
        }
        return state.getShape(level, pos);
    }

    private final boolean isRightCollision(Direction.Axis axis, Direction.Axis axisToCheck, Direction.AxisDirection axisDirection, double motion) {
        return axis == axisToCheck && Math.abs(motion) > 0.01 && (axisDirection == Direction.AxisDirection.NEGATIVE && motion < 0.0 || axisDirection == Direction.AxisDirection.POSITIVE && motion > 0.0);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        boolean isWater = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)SHAPE, (Comparable)(direction.getAxis() == Direction.Axis.Z ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST))).setValue((Property)FACING, (Comparable)direction)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    protected BlockState updateDir(Level level, BlockPos pos, BlockState state, boolean placing) {
        return state;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() == newState.getBlock()) {
            RailShape newShape = (RailShape)newState.getValue((Property)SHAPE);
            Direction newDirection = (Direction)newState.getValue((Property)FACING);
            if (newShape != state.getValue((Property)SHAPE)) {
                if (newDirection.getAxis() == Direction.Axis.Z && newShape != RailShape.NORTH_SOUTH) {
                    level.setBlockAndUpdate(pos, (BlockState)newState.setValue((Property)SHAPE, (Comparable)RailShape.NORTH_SOUTH));
                } else if (newDirection.getAxis() == Direction.Axis.X && newShape != RailShape.EAST_WEST) {
                    level.setBlockAndUpdate(pos, (BlockState)newState.setValue((Property)SHAPE, (Comparable)RailShape.EAST_WEST));
                }
            }
        } else {
            Optional tileEntityOptional = this.getBlockEntity((BlockGetter)level, pos);
            tileEntityOptional.map(BufferStopBlockEntity::getMinecartSlots).ifPresent(minecartSlots -> ItemHandlerUtil.getStackStream((Container)minecartSlots).forEach(stack -> BufferStopBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack)));
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.updatePower(level, state, pos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        this.updatePower(level, state, pos);
    }

    private void updatePower(Level level, BlockState state, BlockPos pos) {
        boolean powered = this.isPowered(level, pos);
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }

    private boolean isPowered(Level level, BlockPos pos) {
        return Stream.of(Direction.values()).anyMatch(direction -> this.isPowered(level, pos, (Direction)direction));
    }

    private boolean isPowered(Level level, BlockPos pos, Direction direction) {
        BlockPos relativePos = pos.relative(direction);
        int value = level.getSignal(relativePos, direction);
        if (value >= 15) {
            return true;
        }
        BlockState relativeState = level.getBlockState(relativePos);
        return Math.max(value, relativeState.getBlock() == Blocks.REDSTONE_WIRE ? (Integer)relativeState.getValue((Property)RedStoneWireBlock.POWER) : 0) > 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return 0.0f;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, POWERED});
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean isFlexibleRail(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    protected MapCodec<? extends BaseRailBlock> codec() {
        return CODEC;
    }
}

