package info.u_team.useful_backpacks.item;

import java.util.ArrayList;
import java.util.List;

import info.u_team.u_team_core.util.TooltipCreator;
import info.u_team.useful_backpacks.UsefulBackpacksReference;
import info.u_team.useful_backpacks.api.Backpack;
import info.u_team.useful_backpacks.api.Filter;
import info.u_team.useful_backpacks.component.ItemFilterComponent;
import info.u_team.useful_backpacks.component.TagFilterComponent;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.inventory.FilterInventory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Item.TooltipContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public interface AutoPickupBackpack extends Backpack {
	
	@Override
	default boolean canAutoPickup(ItemStack stack, ItemStack backpackStack) {
		final FilterInventory filterInventory = new FilterInventory(backpackStack);
		
		for (int index = 0; index < filterInventory.getContainerSize(); index++) {
			final ItemStack filterStack = filterInventory.getItem(index);
			final Item filterItem = filterStack.getItem();
			if (filterItem instanceof final Filter filter) {
				if (filter.matchItem(filterStack, stack)) {
					return true;
				}
			}
		}
		return false;
	}
	
	default void addTooltip(ItemStack stack, TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
		final List<ItemStack> filters = new ArrayList<>();
		
		final FilterInventory filterInventory = new FilterInventory(stack);
		
		for (int index = 0; index < filterInventory.getContainerSize(); index++) {
			final ItemStack filterStack = filterInventory.getItem(index);
			if (filterStack.getItem() instanceof Filter) {
				filters.add(filterStack);
			}
		}
		
		if (!filters.isEmpty()) {
			tooltip.add(TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter", 0).withStyle(ChatFormatting.GREEN, ChatFormatting.ITALIC));
			tooltip.add(CommonComponents.EMPTY);
			if (!flag.isAdvanced()) {
				tooltip.add(TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter_not_advanced", 0).withStyle(ChatFormatting.RED, ChatFormatting.ITALIC));
			} else {
				tooltip.add(TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter_applied", 0).withStyle(ChatFormatting.AQUA));
				
				filters.stream().filter(filterStack -> filterStack.getItem() instanceof ItemFilterItem).forEach(filterStack -> {
					final ItemFilterComponent itemComponent = filterStack.get(UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
					if (itemComponent != null && itemComponent.isPresent()) {
						final MutableComponent component = TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter_applied_item", 0, Component.translatable(itemComponent.getStack().getDescriptionId()).withStyle(ChatFormatting.YELLOW));
						if (itemComponent.isStrict()) {
							component.append(" ").append(TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter_applied_item", 1));
						}
						component.withStyle(ChatFormatting.GRAY);
						tooltip.add(component);
					}
				});
				
				filters.stream().filter(filterStack -> filterStack.getItem() instanceof TagFilterItem).forEach(filterStack -> {
					final TagFilterComponent itemComponent = filterStack.get(UsefulBackpacksDataComponentTypes.TAG_FILTER_COMPONENT.get());
					if (itemComponent != null && itemComponent.isPresent()) {
						final MutableComponent component = TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter_applied_tag", 0, Component.literal(itemComponent.getTag().location().toString()).withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GRAY);
						tooltip.add(component);
					}
				});
			}
		}
	}
}
