package info.u_team.useful_backpacks.screen;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import info.u_team.u_team_core.gui.elements.ScrollableList;
import info.u_team.u_team_core.util.RegistryUtil;
import info.u_team.u_team_core.util.ResourceLocationUtil;
import info.u_team.useful_backpacks.menu.TagFilterMenu;
import io.netty.buffer.Unpooled;

public class TagFilterTagList extends ScrollableList<TagFilterTagListEntry> {
	
	private final TagFilterMenu menu;
	
	public TagFilterTagList(TagFilterMenu menu, int x, int y, int width, int height, String tag) {
		super(x, y, width, height, 10, 15);
		this.menu = menu;
		
		method_25315(false, 0);
		setRenderTransparentBorder(true);
		
		updateEntries(unused -> true);
		
		if (!tag.isEmpty()) {
			method_25396().stream().filter(entry -> entry.getTag().toString().equals(tag)).findAny().ifPresent(entry -> {
				super.method_25313(entry);
				method_25324(entry);
			});
		}
	}
	
	@Override
	public void setSelected(TagFilterTagListEntry entry) {
		super.method_25313(entry);
		
		final String tag = entry.getTag().toString();
		
		menu.getTagMessage().triggerMessage(() -> new class_2540(Unpooled.buffer(100)).method_10814(tag));
		menu.setTag(tag);
	}
	
	public void updateSearch(String search) {
		if (search.isEmpty()) {
			updateEntries(tag -> true);
		} else {
			updateEntries(tag -> {
				if (tag.method_12836().startsWith(search) || tag.method_12832().startsWith(search)) {
					return true;
				}
				return false;
			});
		}
	}
	
	private void updateEntries(Predicate<class_2960> predicate) {
		final List<class_2960> list = RegistryUtil.getBuiltInRegistry(class_7924.field_41197).method_46771().method_46755().filter(tagKey -> predicate.test(tagKey.comp_327())).map(class_6862::comp_327).collect(Collectors.toList());
		Collections.sort(list, ResourceLocationUtil.nameSpacedComparator());
		
		final TagFilterTagListEntry selected = method_25334();
		method_25339();
		method_25307(0);
		list.forEach(tag -> {
			final TagFilterTagListEntry entry = new TagFilterTagListEntry(tag);
			method_25321(entry);
			
			if (selected != null && selected.getTag().equals(tag)) {
				super.method_25313(entry);
			}
		});
		
		if (method_25334() != null) {
			method_25324(method_25334());
		}
	}
	
}
