package info.u_team.useful_backpacks.screen;

import info.u_team.u_team_core.gui.elements.ScalableEditBox;
import info.u_team.u_team_core.screen.UContainerMenuScreen;
import info.u_team.useful_backpacks.UsefulBackpacksReference;
import info.u_team.useful_backpacks.menu.TagFilterMenu;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7919;

public class TagFilterScreen extends UContainerMenuScreen<TagFilterMenu> {
	
	private static final class_2960 BACKGROUND = class_2960.method_60655(UsefulBackpacksReference.MODID, "textures/gui/tag_filter.png");
	
	private final class_2561 tagSearchTextComponent;
	
	private ScalableEditBox tagTextField;
	private TagFilterTagList tagList;
	
	public TagFilterScreen(TagFilterMenu menu, class_1661 playerInventory, class_2561 title) {
		super(menu, playerInventory, title, BACKGROUND, 176, 190);
		
		tagSearchTextComponent = class_2561.method_43471("container.usefulbackpacks.tag_filter.search");
	}
	
	@Override
	protected void method_25426() {
		super.method_25426();
		
		tagTextField = method_37063(new ScalableEditBox(field_22793, field_2776 + 8, field_2800 + 20, 160, 15, tagTextField, tagSearchTextComponent, 0.75F));
		tagTextField.method_1880(300);
		tagTextField.method_47400(class_7919.method_47407(tagSearchTextComponent));
		tagTextField.method_1863(search -> {
			tagList.updateSearch(search);
		});
		method_48265(tagTextField);
		
		tagList = method_37063(new TagFilterTagList(field_2797, field_2776 + 7, field_2800 + 40, 161, 52, field_2797.getTag()));
	}
	
	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (keyCode == 256 && method_25422()) {
			method_25419();
			return true;
		}
		return !tagTextField.method_25404(keyCode, scanCode, modifiers) && !tagTextField.method_20315() ? super.method_25404(keyCode, scanCode, modifiers) : true;
	}
	
	@Override
	public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
		final boolean dragged = method_25399() != null && method_25397() && button == 0 ? method_25399().method_25403(mouseX, mouseY, button, dragX, dragY) : false;
		if (!dragged) {
			return super.method_25403(mouseX, mouseY, button, dragX, dragY);
		}
		return true;
	}
}
