package info.u_team.useful_backpacks.screen;

import info.u_team.u_team_core.gui.elements.CheckboxButton;
import info.u_team.u_team_core.screen.UContainerMenuScreen;
import info.u_team.useful_backpacks.UsefulBackpacksReference;
import info.u_team.useful_backpacks.menu.ItemFilterMenu;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7919;

public class ItemFilterScreen extends UContainerMenuScreen<ItemFilterMenu> {
	
	private static final class_2960 BACKGROUND = class_2960.method_60655(UsefulBackpacksReference.MODID, "textures/gui/item_filter.png");
	
	private final class_2561 strictTextComponent;
	private final class_2561 strictTooltipTextComponent;
	
	private CheckboxButton isStrictCheckbox;
	
	public ItemFilterScreen(ItemFilterMenu menu, class_1661 playerInventory, class_2561 title) {
		super(menu, playerInventory, title, BACKGROUND, 176, 130);
		
		final String langKey = "container.usefulbackpacks.item_filter.";
		
		strictTextComponent = class_2561.method_43471(langKey + "strict");
		strictTooltipTextComponent = class_2561.method_43471(langKey + "strict.tooltip");
	}
	
	@Override
	protected void method_25426() {
		super.method_25426();
		
		isStrictCheckbox = method_37063(new CheckboxButton(field_2776 + field_2792 - (17 + 16), field_2800 + 17, 16, 16, strictTextComponent, field_2797.isStrict(), true));
		isStrictCheckbox.setTextColor(DEFAULT_TEXT_COLOR);
		isStrictCheckbox.setLeftSideText(true);
		isStrictCheckbox.setPressable(() -> {
			field_2797.getStrictMessage().triggerMessage(() -> new class_2540(Unpooled.copyBoolean(isStrictCheckbox.isChecked())));
			field_2797.setStrict(isStrictCheckbox.isChecked());
		});
		isStrictCheckbox.method_47400(class_7919.method_47407(strictTooltipTextComponent));
		isStrictCheckbox.field_22764 = field_2797.hasFilterItem();
	}
	
	@Override
	public void method_37432() {
		super.method_37432();
		if (isStrictCheckbox != null) {
			isStrictCheckbox.field_22764 = field_2797.hasFilterItem();
		}
	}
}
