package info.u_team.useful_backpacks.recipe;

import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9282;
import net.minecraft.class_9694;
import com.google.common.collect.Lists;

import info.u_team.u_team_core.recipeserializer.UShapedRecipeSerializer;
import info.u_team.u_team_core.util.ColorUtil;
import info.u_team.useful_backpacks.init.UsefulBackpacksRecipeSerializers;
import info.u_team.useful_backpacks.item.BackpackItem;

public class BackpackCraftingRecipe extends class_1869 {
	
	public BackpackCraftingRecipe(String group, class_7710 category, class_8957 pattern, class_1799 result, boolean showNotification) {
		super(group, category, pattern, result, showNotification);
	}
	
	@Override
	public class_1799 method_17727(class_9694 input, class_7225.class_7874 registries) {
		final class_1799 backpackItem = super.method_17727(input, registries);
		final List<class_1769> dyeList = Lists.newArrayList();
		
		boolean backpackPresent = false;
		
		for (int index = 0; index < input.method_59983(); ++index) {
			final class_1799 slotStack = input.method_59984(index);
			if (!slotStack.method_7960()) {
				final class_1792 item = slotStack.method_7909();
				if (item instanceof BackpackItem) {
					if (backpackPresent) { // Does not allow multiple backpacks if somebody changed the recipe to be so
						return class_1799.field_8037;
					}
					backpackPresent = true;
					backpackItem.method_59692(slotStack.method_57380()); // Copy tag from existing one including color and inventory if exist
				} else {
					if (slotStack.method_31573(class_3489.field_15544)) {
						final class_1767 color = ColorUtil.getColorFromWool(item);
						if (color != null) {
							dyeList.add(class_1769.method_7803(color));
						}
					}
				}
			}
		}
		if (!dyeList.isEmpty() && !dyeList.parallelStream().allMatch(item -> item.method_7802() == class_1767.field_7952)) { // Don't change color if all color is white (neutral element).
			return class_9282.method_57471(backpackItem, dyeList);
		}
		return backpackItem;
	}
	
	@Override
	public class_1865<?> method_8119() {
		return UsefulBackpacksRecipeSerializers.BACKPACK.get();
	}
	
	public static class Serializer extends UShapedRecipeSerializer<BackpackCraftingRecipe> {
		
		@Override
		protected BackpackCraftingRecipe createRecipe(String group, class_7710 category, class_8957 pattern, class_1799 result, boolean showNotification) {
			return new BackpackCraftingRecipe(group, category, pattern, result, showNotification);
		}
	}
}
