package info.u_team.useful_backpacks.menu;

import info.u_team.u_team_core.api.sync.MessageHolder;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_backpacks.component.TagFilterComponent;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.init.UsefulBackpacksMenuTypes;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class TagFilterMenu extends UContainerMenu {
	
	private final int selectedSlot;
	private String tag;
	
	private final MessageHolder tagMessage;
	
	public TagFilterMenu(int id, class_1661 playerInventory, class_2540 buffer) {
		this(id, playerInventory, class_1799.field_8037, buffer.method_10816(), buffer.method_19772());
	}
	
	public TagFilterMenu(int id, class_1661 playerInventory, class_1799 filterStack, int selectedSlot, String tag) {
		super(UsefulBackpacksMenuTypes.TAG_FILTER.get(), id);
		this.selectedSlot = selectedSlot;
		this.tag = tag;
		
		addPlayerInventory(playerInventory, 8, 108);
		
		tagMessage = addDataHolderToServer(new MessageHolder(buffer -> {
			final String newTag = buffer.method_19772();
			if (!filterStack.method_7960()) {
				if (newTag.isEmpty()) {
					filterStack.method_57379(UsefulBackpacksDataComponentTypes.TAG_FILTER_COMPONENT.get(), TagFilterComponent.EMPTY);
				} else {
					final class_2960 location = class_2960.method_12829(newTag);
					if (location != null) {
						filterStack.method_57379(UsefulBackpacksDataComponentTypes.TAG_FILTER_COMPONENT.get(), TagFilterComponent.of(location));
					}
				}
			}
		}));
	}
	
	@Override
	public boolean method_7597(class_1657 player) {
		return true;
	}
	
	@Override
	public void method_7593(int slotId, int dragType, class_1713 clickType, class_1657 player) {
		class_1735 tmpSlot;
		if (slotId >= 0 && slotId < field_7761.size()) {
			tmpSlot = field_7761.get(slotId);
		} else {
			tmpSlot = null;
		}
		if (tmpSlot != null) {
			if (tmpSlot.field_7871 == player.method_31548() && tmpSlot.method_34266() == selectedSlot) {
				return;
			}
		}
		if (clickType == class_1713.field_7791) {
			final class_1799 stack = player.method_31548().method_5438(dragType);
			final class_1799 currentItem = class_1661.method_7380(selectedSlot) ? player.method_31548().field_7547.get(selectedSlot) : selectedSlot == -1 ? player.method_31548().field_7544.get(0) : class_1799.field_8037;
			
			if (!currentItem.method_7960() && stack == currentItem) {
				return;
			}
		}
		super.method_7593(slotId, dragType, clickType, player);
	}
	
	public String getTag() {
		return tag;
	}
	
	public void setTag(String tag) {
		this.tag = tag;
	}
	
	public MessageHolder getTagMessage() {
		return tagMessage;
	}
	
	@Override
	public class_1799 method_7601(class_1657 player, int index) {
		class_1799 itemstack = class_1799.field_8037;
		final class_1735 slot = field_7761.get(index);
		
		if (slot != null && slot.method_7681()) {
			final class_1799 itemstack1 = slot.method_7677();
			itemstack = itemstack1.method_7972();
			
			if (index < 27) {
				if (!method_7616(itemstack1, 27, 36, false)) {
					return class_1799.field_8037;
				}
			} else if (!method_7616(itemstack1, 0, 27, false)) {
				return class_1799.field_8037;
			}
			
			if (itemstack1.method_7960()) {
				slot.method_7673(class_1799.field_8037);
			} else {
				slot.method_7668();
			}
		}
		return itemstack;
	}
}
