package info.u_team.useful_backpacks.menu;

import info.u_team.u_team_core.api.sync.MessageHolder;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_backpacks.component.ItemFilterComponent;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.init.UsefulBackpacksMenuTypes;
import info.u_team.useful_backpacks.menu.slot.ItemFilterSlot;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;

public class ItemFilterMenu extends UContainerMenu {
	
	private final class_1799 filterStack;
	private final int selectedSlot;
	private boolean isStrict;
	
	private final class_1263 filterItemSlotInventory = new class_1277(1);
	
	private final MessageHolder strictMessage;
	
	public ItemFilterMenu(int id, class_1661 playerInventory, class_2540 buffer) {
		this(id, playerInventory, class_1799.field_8037, buffer.method_10816(), buffer.readBoolean());
	}
	
	public ItemFilterMenu(int id, class_1661 playerInventory, class_1799 filterStack, int selectedSlot, boolean isStrict) {
		super(UsefulBackpacksMenuTypes.ITEM_FILTER.get(), id);
		this.filterStack = filterStack;
		this.selectedSlot = selectedSlot;
		this.isStrict = isStrict;
		
		final ItemFilterComponent component = filterStack.method_57824(UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
		if (component != null && component.isPresent()) {
			filterItemSlotInventory.method_5447(0, component.getStack());
		}
		
		addSlots((index, xPosition, yPosition) -> new ItemFilterSlot(filterItemSlotInventory, index, xPosition, yPosition), 1, 1, 17, 17);
		addPlayerInventory(playerInventory, 8, 48);
		
		strictMessage = addDataHolderToServer(new MessageHolder(buffer -> {
			final boolean newIsStrict = buffer.readBoolean();
			if (!filterStack.method_7960()) {
				filterStack.method_57368(UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get(), ItemFilterComponent.EMPTY, old -> {
					if (!old.isPresent()) {
						return ItemFilterComponent.EMPTY;
					} else {
						return ItemFilterComponent.of(newIsStrict, old.getStack());
					}
				});
			}
		}));
	}
	
	@Override
	public boolean method_7597(class_1657 player) {
		return true;
	}
	
	@Override
	public void method_7623() {
		if (!filterStack.method_7960()) {
			final class_1799 stackToFilter = filterItemSlotInventory.method_5438(0);
			
			filterStack.method_57368(UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get(), ItemFilterComponent.EMPTY, old -> {
				return ItemFilterComponent.of(old.isStrict(), stackToFilter);
			});
		}
		
		super.method_7623();
	}
	
	@Override
	public void method_7593(int slotId, int dragType, class_1713 clickType, class_1657 player) {
		if (slotId == 0) {
			filterSlotClick(dragType, clickType, player);
			return;
		}
		
		class_1735 tmpSlot;
		if (slotId >= 0 && slotId < field_7761.size()) {
			tmpSlot = field_7761.get(slotId);
		} else {
			tmpSlot = null;
		}
		if (tmpSlot != null) {
			if (tmpSlot.field_7871 == player.method_31548() && tmpSlot.method_34266() == selectedSlot) {
				return;
			}
		}
		if (clickType == class_1713.field_7791) {
			final class_1799 stack = player.method_31548().method_5438(dragType);
			final class_1799 currentItem = class_1661.method_7380(selectedSlot) ? player.method_31548().field_7547.get(selectedSlot) : selectedSlot == -1 ? player.method_31548().field_7544.get(0) : class_1799.field_8037;
			
			if (!currentItem.method_7960() && stack == currentItem) {
				return;
			}
		}
		super.method_7593(slotId, dragType, clickType, player);
	}
	
	private class_1799 filterSlotClick(int dragType, class_1713 clickType, class_1657 player) {
		final class_1799 stack;
		
		if (clickType == class_1713.field_7795) {
			filterItemSlotInventory.method_5447(0, class_1799.field_8037);
			stack = class_1799.field_8037;
		} else if (clickType == class_1713.field_7790 || clickType == class_1713.field_7796) {
			stack = method_34255().method_7972();
			stack.method_7939(1);
			filterItemSlotInventory.method_5447(0, stack);
		} else if (clickType == class_1713.field_7791) {
			stack = player.method_31548().method_5438(dragType).method_7972();
			stack.method_7939(1);
			filterItemSlotInventory.method_5447(0, stack);
		} else {
			stack = class_1799.field_8037;
		}
		return stack;
	}
	
	public boolean isStrict() {
		return isStrict;
	}
	
	public void setStrict(boolean isStrict) {
		this.isStrict = isStrict;
	}
	
	public MessageHolder getStrictMessage() {
		return strictMessage;
	}
	
	public boolean hasFilterItem() {
		return !filterItemSlotInventory.method_5438(0).method_7960();
	}
	
	@Override
	public class_1799 method_7601(class_1657 player, int index) {
		class_1799 itemstack = class_1799.field_8037;
		final class_1735 slot = field_7761.get(index);
		
		if (slot != null && slot.method_7681()) {
			final class_1799 itemstack1 = slot.method_7677();
			itemstack = itemstack1.method_7972();
			
			if (index < 1) {
				return class_1799.field_8037;
			} else {
				final class_1799 stack = itemstack1.method_7972();
				stack.method_7939(1);
				filterItemSlotInventory.method_5447(0, stack);
				return class_1799.field_8037;
			}
		}
		return itemstack;
	}
	
}
