package info.u_team.useful_backpacks.menu;

import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3914;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_backpacks.api.Backpack;
import info.u_team.useful_backpacks.init.UsefulBackpacksBlocks;
import info.u_team.useful_backpacks.init.UsefulBackpacksMenuTypes;
import info.u_team.useful_backpacks.inventory.DelegateInventory;
import info.u_team.useful_backpacks.inventory.FilterInventory;
import info.u_team.useful_backpacks.menu.slot.BackpackFilterSlot;
import info.u_team.useful_backpacks.menu.slot.FilterSlot;

public class FilterConfiguratorMenu extends UContainerMenu {
	
	private final class_3914 access;
	
	private final class_1263 backpackSlotInventory = new class_1277(1) {
		
		@Override
		public void method_5431() {
			super.method_5431();
			method_7609(this);
		}
	};
	private final DelegateInventory filterSlotInventory = new DelegateInventory(new class_1277(9));
	
	private class_1263 filterInventory;
	
	// Client
	public FilterConfiguratorMenu(int id, class_1661 playerInventory) {
		this(id, playerInventory, class_3914.field_17304);
		filterInventory = new class_1277(9);
	}
	
	// Server
	public FilterConfiguratorMenu(int id, class_1661 playerInventory, class_3914 access) {
		super(UsefulBackpacksMenuTypes.FILTER_CONFIGURATOR.get(), id);
		this.access = access;
		
		addSlots((index, xPosition, yPosition) -> new BackpackFilterSlot(backpackSlotInventory, index, xPosition, yPosition), 1, 1, 35, 35);
		addSlots((index, xPosition, yPosition) -> new FilterSlot(backpackSlotInventory, filterSlotInventory, index, xPosition, yPosition), 3, 3, 89, 17);
		addPlayerInventory(playerInventory, 8, 84);
	}
	
	@Override
	public boolean method_7597(class_1657 player) {
		return method_17695(access, player, UsefulBackpacksBlocks.FILTER_CONFIGURATOR.get());
	}
	
	@Override
	public void method_7595(class_1657 player) {
		super.method_7595(player);
		saveFilterInventory();
		access.method_17393((level, pos) -> method_7607(player, backpackSlotInventory));
	}
	
	@Override
	public void method_7623() {
		final List<class_1799> lastSlots = getLastSlots();
		
		final class_1799 oldStack = lastSlots.get(0);
		final class_1799 newStack = backpackSlotInventory.method_5438(0);
		
		final boolean stackChanged = !class_1799.method_7973(oldStack, newStack);
		
		if (stackChanged) {
			if (newStack.method_7909() instanceof Backpack) {
				if (filterInventory instanceof FilterInventory) {
					((FilterInventory) filterInventory).writeItemStack();
				}
				filterInventory = new FilterInventory(backpackSlotInventory.method_5438(0));
				filterSlotInventory.setInventory(filterInventory);
			} else if (newStack.method_7960() && filterInventory instanceof FilterInventory) {
				filterInventory = null;
				filterSlotInventory.setInventory(null);
			}
		}
		saveFilterInventory();
		super.method_7623();
	}
	
	private void saveFilterInventory() {
		if (filterInventory instanceof final FilterInventory inventory) {
			inventory.writeItemStack();
		}
	}
	
	@Override
	public class_1799 method_7601(class_1657 player, int index) {
		class_1799 itemstack = class_1799.field_8037;
		final class_1735 slot = field_7761.get(index);
		
		if (slot != null && slot.method_7681()) {
			final class_1799 itemstack1 = slot.method_7677();
			itemstack = itemstack1.method_7972();
			
			if (index < 10) {
				if (!method_7616(itemstack1, 10, field_7761.size(), true)) {
					return class_1799.field_8037;
				}
			} else if (!method_7616(itemstack1, 0, 10, false)) {
				return class_1799.field_8037;
			}
			
			if (itemstack1.method_7960()) {
				slot.method_7673(class_1799.field_8037);
			} else {
				slot.method_7668();
			}
		}
		return itemstack;
	}
}
