package info.u_team.useful_backpacks.menu;

import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_backpacks.api.Backpack;
import info.u_team.useful_backpacks.init.UsefulBackpacksMenuTypes;
import info.u_team.useful_backpacks.inventory.BackpackInventory;
import info.u_team.useful_backpacks.menu.slot.BackpackSlot;
import info.u_team.useful_backpacks.type.BackpackType;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;

public class BackpackMenu extends UContainerMenu {
	
	private final class_1263 backpackInventory;
	private final BackpackType backpack;
	private final int selectedSlot;
	
	// Client
	public static BackpackMenu createClientContainer(int id, class_1661 playerInventory, class_2540 buffer) {
		final BackpackType backpack = buffer.method_10818(BackpackType.class);
		final int selectedSlot = buffer.method_10816();
		return new BackpackMenu(id, playerInventory, new class_1277(backpack.getInventorySize()), backpack, selectedSlot);
	}
	
	// Server
	public BackpackMenu(int id, class_1661 playerInventory, class_1263 backpackInventory, BackpackType backpack, int selectedSlot) {
		super(UsefulBackpacksMenuTypes.BACKPACK.get(), id);
		this.backpackInventory = backpackInventory;
		this.backpack = backpack;
		this.selectedSlot = selectedSlot;
		addBackpackInventory(backpack.getSlotBackpackX(), backpack.getSlotBackpackY());
		addPlayerInventory(playerInventory, backpack.getSlotPlayerX(), backpack.getSlotPlayerY());
	}
	
	public void addBackpackInventory(int x, int y) {
		for (int height = 0; height < backpack.getInventoryHeight(); height++) {
			for (int width = 0; width < backpack.getInventoryWidth(); width++) {
				method_7621(new BackpackSlot(backpackInventory, width + height * backpack.getInventoryWidth(), width * 18 + x, height * 18 + y));
			}
		}
	}
	
	@Override
	public void method_7623() {
		super.method_7623();
		if (backpackInventory instanceof final BackpackInventory inventory) {
			inventory.writeItemStack();
		}
	}
	
	@Override
	public class_1799 method_7601(class_1657 player, int index) {
		class_1799 itemstack = class_1799.field_8037;
		final class_1735 slot = field_7761.get(index);
		
		if (slot != null && slot.method_7681()) {
			final class_1799 itemstack1 = slot.method_7677();
			itemstack = itemstack1.method_7972();
			
			if (index < backpack.getInventorySize()) {
				if (!method_7616(itemstack1, backpack.getInventorySize(), field_7761.size(), true)) {
					return class_1799.field_8037;
				}
			} else if (!method_7616(itemstack1, 0, backpack.getInventorySize(), false)) {
				return class_1799.field_8037;
			}
			
			if (itemstack1.method_7960()) {
				slot.method_7673(class_1799.field_8037);
			} else {
				slot.method_7668();
			}
		}
		return itemstack;
	}
	
	@Override
	public void method_7593(int slotId, int dragType, class_1713 clickType, class_1657 player) {
		class_1735 tmpSlot;
		if (slotId >= 0 && slotId < field_7761.size()) {
			tmpSlot = field_7761.get(slotId);
		} else {
			tmpSlot = null;
		}
		if (tmpSlot != null) {
			if (tmpSlot.field_7871 == player.method_31548() && tmpSlot.method_34266() == selectedSlot) {
				return;
			}
		}
		if (clickType == class_1713.field_7791) {
			final class_1799 stack = player.method_31548().method_5438(dragType);
			final class_1799 currentItem = class_1661.method_7380(selectedSlot) ? player.method_31548().field_7547.get(selectedSlot) : selectedSlot == -1 ? player.method_31548().field_7544.get(0) : class_1799.field_8037;
			
			if (!currentItem.method_7960() && stack == currentItem) {
				return;
			}
		}
		super.method_7593(slotId, dragType, clickType, player);
	}
	
	@Override
	public boolean method_7597(class_1657 player) {
		if (backpackInventory instanceof final BackpackInventory inventory) {
			final class_1799 stack = inventory.getStack();
			return !stack.method_7960() && stack.method_7909() instanceof Backpack;
		}
		return true;
	}
	
	public BackpackType getBackpack() {
		return backpack;
	}
	
	public class_1263 getBackpackInventory() {
		return backpackInventory;
	}
}
