package info.u_team.useful_backpacks.item;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_747;
import info.u_team.u_team_core.util.MenuUtil;
import info.u_team.u_team_core.util.TooltipCreator;
import info.u_team.useful_backpacks.UsefulBackpacksReference;
import info.u_team.useful_backpacks.component.ItemFilterComponent;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.menu.ItemFilterMenu;

public class ItemFilterItem extends FilterItem {
	
	@Override
	public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
		final class_1799 stack = player.method_5998(hand);
		if (!level.field_9236 && player instanceof final class_3222 serverPlayer) {
			if (player.method_5715()) {
				stack.method_57379(UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get(), ItemFilterComponent.EMPTY);
			} else {
				final int selectedSlot = hand == class_1268.field_5808 ? player.method_31548().field_7545 : -1;
				
				final ItemFilterComponent component = stack.method_57824(UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
				final boolean isStrict;
				if (component == null) {
					isStrict = false;
				} else {
					isStrict = component.isStrict();
				}
				MenuUtil.openMenu(serverPlayer, new class_747((id, playerInventory, unused) -> {
					return new ItemFilterMenu(id, playerInventory, stack, selectedSlot, isStrict);
				}, stack.method_7964()), buffer -> {
					buffer.method_10804(selectedSlot);
					buffer.method_52964(isStrict);
				}, false);
			}
		}
		return class_1271.method_22427(stack);
	}
	
	@Override
	protected boolean matches(class_1799 filterStack, class_1799 matchStack) {
		final ItemFilterComponent component = filterStack.method_57824(UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
		final boolean strict = component.isStrict();
		final class_1799 stack = component.getStack();
		
		if (strict) {
			return class_1799.method_31577(stack, matchStack);
		} else {
			return class_1799.method_7984(stack, matchStack);
		}
	}
	
	@Override
	public boolean isUsable(class_1799 filterStack) {
		if (filterStack.method_7909() instanceof ItemFilterItem) {
			final ItemFilterComponent component = filterStack.method_57824(UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
			if (component != null) {
				return component.isPresent() && !component.getStack().method_7960();
			}
		}
		return false;
	}
	
	@Override
	public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 flag) {
		if (!isUsable(stack)) {
			tooltip.add(TooltipCreator.create(this, "not_configured", 0).method_27695(class_124.field_1061, class_124.field_1056));
			tooltip.add(TooltipCreator.create(this, "not_configured", 1, TooltipCreator.create(UsefulBackpacksReference.MODID, "click", "right_click", 0).method_27695(class_124.field_1056, class_124.field_1065)).method_27692(class_124.field_1080));
		} else {
			final ItemFilterComponent component = stack.method_57824(UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
			tooltip.add(TooltipCreator.create(this, "configured", 0).method_27695(class_124.field_1060, class_124.field_1056));
			tooltip.add(TooltipCreator.create(this, "configured", 1, class_2561.method_43471(component.getStack().method_7922()).method_27692(class_124.field_1054)).method_27692(class_124.field_1080));
			tooltip.add(TooltipCreator.create(this, "configured", 2, class_2561.method_43470(Boolean.toString(component.isStrict())).method_27692(class_124.field_1054)).method_27692(class_124.field_1080));
			tooltip.add(TooltipCreator.create(this, "configured", 3, TooltipCreator.create(UsefulBackpacksReference.MODID, "click", "shift_right_click", 0).method_27695(class_124.field_1056, class_124.field_1065)).method_27692(class_124.field_1080));
		}
	}
	
	@Override
	public boolean canBeDropped(class_1799 stack, class_1657 player) {
		return !(player.field_7512 instanceof ItemFilterMenu);
	}
}
