package info.u_team.useful_backpacks.item;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_747;
import net.minecraft.class_9288;
import info.u_team.u_team_core.item.UItem;
import info.u_team.u_team_core.util.MenuUtil;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.inventory.BackpackInventory;
import info.u_team.useful_backpacks.menu.BackpackMenu;
import info.u_team.useful_backpacks.type.BackpackType;

public class BackpackItem extends UItem implements AutoPickupBackpack {
	
	public static final int DEFAULT_COLOR = 0x816040;
	
	private final BackpackType backpack;
	
	public BackpackItem(BackpackType backpack) {
		super(new class_1793().method_7889(1).method_7894(backpack.getRarity()) //
				.method_57349(UsefulBackpacksDataComponentTypes.BACKPACK_COMPONENT.get(), class_9288.field_49334) //
				.method_57349(UsefulBackpacksDataComponentTypes.FILTER_COMPONENT.get(), class_9288.field_49334));
		this.backpack = backpack;
	}
	
	@Override
	public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
		final class_1799 stack = player.method_5998(hand);
		if (!level.field_9236 && player instanceof class_3222) {
			open((class_3222) player, stack, hand == class_1268.field_5808 ? player.method_31548().field_7545 : -1);
		}
		return class_1271.method_22427(stack);
	}
	
	@Override
	public void open(class_3222 player, class_1799 backpackStack, int selectedSlot) {
		MenuUtil.openMenu(player, new class_747((id, playerInventory, unused) -> {
			return new BackpackMenu(id, playerInventory, getInventory(player, backpackStack), backpack, selectedSlot);
		}, backpackStack.method_7964()), buffer -> {
			buffer.method_10817(backpack);
			buffer.method_10804(selectedSlot);
		}, false);
	}
	
	@Override
	public class_1277 getInventory(class_3222 player, class_1799 backpackStack) {
		return new BackpackInventory(backpackStack, backpack.getInventorySize());
	}
	
	@Override
	public void saveInventory(class_1277 inventory, class_1799 backpackStack) {
		if (inventory instanceof final BackpackInventory backpackInventory) {
			backpackInventory.writeItemStack();
		}
	}
	
	@Override
	public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 flag) {
		addTooltip(stack, context, tooltip, flag);
	}
	
	public BackpackType getBackpack() {
		return backpack;
	}
	
	@Override
	public boolean shouldPlayUpdateAnimation(class_1799 oldStack, class_1799 newStack) {
		return !class_1799.method_7984(oldStack, newStack);
	}
	
	@Override
	public boolean canBeDropped(class_1799 stack, class_1657 player) {
		return !(player.field_7512 instanceof BackpackMenu);
	}
}
