package info.u_team.useful_backpacks.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_9635;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import info.u_team.u_team_core.util.TooltipCreator;
import info.u_team.useful_backpacks.UsefulBackpacksReference;
import info.u_team.useful_backpacks.api.Backpack;
import info.u_team.useful_backpacks.api.Filter;
import info.u_team.useful_backpacks.component.ItemFilterComponent;
import info.u_team.useful_backpacks.component.TagFilterComponent;
import info.u_team.useful_backpacks.init.UsefulBackpacksDataComponentTypes;
import info.u_team.useful_backpacks.inventory.FilterInventory;

public interface AutoPickupBackpack extends Backpack {
	
	@Override
	default boolean canAutoPickup(class_1799 stack, class_1799 backpackStack) {
		final FilterInventory filterInventory = new FilterInventory(backpackStack);
		
		for (int index = 0; index < filterInventory.method_5439(); index++) {
			final class_1799 filterStack = filterInventory.method_5438(index);
			final class_1792 filterItem = filterStack.method_7909();
			if (filterItem instanceof final Filter filter) {
				if (filter.matchItem(filterStack, stack)) {
					return true;
				}
			}
		}
		return false;
	}
	
	default void addTooltip(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 flag) {
		final List<class_1799> filters = new ArrayList<>();
		
		final FilterInventory filterInventory = new FilterInventory(stack);
		
		for (int index = 0; index < filterInventory.method_5439(); index++) {
			final class_1799 filterStack = filterInventory.method_5438(index);
			if (filterStack.method_7909() instanceof Filter) {
				filters.add(filterStack);
			}
		}
		
		if (!filters.isEmpty()) {
			tooltip.add(TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter", 0).method_27695(class_124.field_1060, class_124.field_1056));
			tooltip.add(class_5244.field_39003);
			if (!flag.method_8035()) {
				tooltip.add(TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter_not_advanced", 0).method_27695(class_124.field_1061, class_124.field_1056));
			} else {
				tooltip.add(TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter_applied", 0).method_27692(class_124.field_1075));
				
				filters.stream().filter(filterStack -> filterStack.method_7909() instanceof ItemFilterItem).forEach(filterStack -> {
					final ItemFilterComponent itemComponent = filterStack.method_57824(UsefulBackpacksDataComponentTypes.ITEM_FILTER_COMPONENT.get());
					if (itemComponent != null && itemComponent.isPresent()) {
						final class_5250 component = TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter_applied_item", 0, class_2561.method_43471(itemComponent.getStack().method_7922()).method_27692(class_124.field_1054));
						if (itemComponent.isStrict()) {
							component.method_27693(" ").method_10852(TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter_applied_item", 1));
						}
						component.method_27692(class_124.field_1080);
						tooltip.add(component);
					}
				});
				
				filters.stream().filter(filterStack -> filterStack.method_7909() instanceof TagFilterItem).forEach(filterStack -> {
					final TagFilterComponent itemComponent = filterStack.method_57824(UsefulBackpacksDataComponentTypes.TAG_FILTER_COMPONENT.get());
					if (itemComponent != null && itemComponent.isPresent()) {
						final class_5250 component = TooltipCreator.create(UsefulBackpacksReference.MODID, "backpack", "filter_applied_tag", 0, class_2561.method_43470(itemComponent.getTag().comp_327().toString()).method_27692(class_124.field_1054)).method_27692(class_124.field_1080);
						tooltip.add(component);
					}
				});
			}
		}
	}
}
