package info.u_team.useful_backpacks.integration.jei.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.google.common.collect.Lists;

import info.u_team.u_team_core.util.ColorUtil;
import info.u_team.u_team_core.util.RGB;
import info.u_team.useful_backpacks.item.BackpackItem;
import info.u_team.useful_backpacks.recipe.BackpackCraftingRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_8786;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class BackpackCraftingRecipeCategoryExtension implements ICraftingCategoryExtension<BackpackCraftingRecipe> {
	
	@Override
	public int getWidth(class_8786<BackpackCraftingRecipe> holder) {
		return holder.comp_1933().method_8150();
	}
	
	@Override
	public int getHeight(class_8786<BackpackCraftingRecipe> holder) {
		return holder.comp_1933().method_8158();
	}
	
	@Override
	public void setRecipe(class_8786<BackpackCraftingRecipe> holder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
		final BackpackCraftingRecipe recipe = holder.comp_1933();
		final List<List<class_1799>> inputs = recipe.method_8117().stream().map(ingredient -> Lists.newArrayList(ingredient.method_8105())).collect(Collectors.toCollection(ArrayList::new));
		final List<class_1799> outputs = Lists.newArrayList(recipe.method_8110(class_310.method_1551().field_1687.method_30349()));
		
		final AtomicBoolean changed = new AtomicBoolean(false);
		
		focuses.getItemStackFocuses(RecipeIngredientRole.OUTPUT) //
				.map(focus -> focus.getTypedValue().getIngredient()) //
				.findFirst().ifPresent(outputStack -> {
					final class_9282 dyedColor = outputStack.method_57824(class_9334.field_49644);
					if (dyedColor != null) {
						final int dyeableColor = dyedColor.comp_2384();
						final class_1767 color = ColorUtil.findClosestDyeColor(new RGB(dyeableColor));
						final class_2248 wool = ColorUtil.getWoolFromColor(color);
						for (int index = 0; index < inputs.size(); index++) {
							final List<class_1799> list = inputs.get(index);
							if (list.stream().allMatch(stack -> stack.method_31573(class_3489.field_15544))) {
								if (dyeableColor != BackpackItem.DEFAULT_COLOR) {
									inputs.set(index, List.of(new class_1799(wool)));
								} else {
									inputs.set(index, List.of(new class_1799(class_2246.field_10446)));
								}
							}
						}
						outputs.set(0, class_9282.method_57471(outputs.get(0), List.of(class_1769.method_7803(color))));
						changed.set(true);
					}
				});
		
		focuses.getItemStackFocuses(RecipeIngredientRole.INPUT) //
				.map(focus -> focus.getTypedValue().getIngredient()) //
				.findFirst().ifPresent(inputStack -> {
					if (inputStack.method_31573(class_3489.field_15544)) {
						final class_1767 color = ColorUtil.getColorFromWool(inputStack.method_7909());
						if (color != null && color != class_1767.field_7952) {
							outputs.set(0, class_9282.method_57471(outputs.get(0), List.of(class_1769.method_7803(color))));
						}
						changed.set(true);
					}
				});
		
		if (!changed.get()) {
			Stream.of(class_1767.values()).map(color -> {
				if (color == class_1767.field_7952) {
					return outputs.get(0);
				}
				return class_9282.method_57471(outputs.get(0), List.of(class_1769.method_7803(color)));
			}).forEach(outputs::add);
			outputs.remove(0);
		}
		
		craftingGridHelper.createAndSetInputs(builder, VanillaTypes.ITEM_STACK, inputs, getWidth(holder), getHeight(holder));
		craftingGridHelper.createAndSetOutputs(builder, VanillaTypes.ITEM_STACK, outputs);
	}
	
}
