package info.u_team.useful_backpacks.integration.jei;

import org.jetbrains.annotations.Nullable;

import info.u_team.useful_backpacks.UsefulBackpacksReference;
import info.u_team.useful_backpacks.init.UsefulBackpacksItems;
import info.u_team.useful_backpacks.integration.jei.extension.BackpackCraftingRecipeCategoryExtension;
import info.u_team.useful_backpacks.recipe.BackpackCraftingRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

@JeiPlugin
public class UsefulBackpacksJeiPlugin implements IModPlugin {
	
	private final class_2960 id = class_2960.method_60655(UsefulBackpacksReference.MODID, "jei");
	
	@Override
	public class_2960 getPluginUid() {
		return id;
	}
	
	@Override
	public void registerItemSubtypes(ISubtypeRegistration registration) {
		final ISubtypeInterpreter<class_1799> interpreter = new ISubtypeInterpreter<>() {
			
			@Override
			public @Nullable Object getSubtypeData(class_1799 stack, UidContext context) {
				if (context == UidContext.Ingredient) {
					return stack.method_57824(class_9334.field_49644);
				}
				return null;
			}
			
			@Override
			public String getLegacyStringSubtypeInfo(class_1799 stack, UidContext context) {
				if (context == UidContext.Ingredient) {
					final class_9282 color = stack.method_57824(class_9334.field_49644);
					if (color != null) {
						return Integer.toString(color.comp_2384());
					}
				}
				return "";
			}
		};
		
		registration.registerSubtypeInterpreter(UsefulBackpacksItems.SMALL_BACKPACK.get(), interpreter);
		registration.registerSubtypeInterpreter(UsefulBackpacksItems.MEDIUM_BACKPACK.get(), interpreter);
		registration.registerSubtypeInterpreter(UsefulBackpacksItems.LARGE_BACKPACK.get(), interpreter);
	}
	
	@Override
	public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
		registration.getCraftingCategory().addExtension(BackpackCraftingRecipe.class, new BackpackCraftingRecipeCategoryExtension());
	}
}
