package info.u_team.useful_backpacks.event;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1277;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import info.u_team.useful_backpacks.api.Backpack;
import info.u_team.useful_backpacks.config.CommonConfig;
import info.u_team.useful_backpacks.inventory.BackpackInventory;
import info.u_team.useful_backpacks.item.BackpackItem;
import info.u_team.useful_backpacks.menu.BackpackMenu;

public class ItemPickupCommonEventHandler {
	
	public static final List<Function<class_3222, class_1799>> INTEGRATION_BACKPACKS = new ArrayList<>();
	
	public static class_1799 insertInBackpacks(class_3222 player, class_1799 stackToPickup) {
		if (stackToPickup.method_7909() instanceof Backpack && !CommonConfig.getInstance().allowStackingBackpacks().get()) {
			return stackToPickup;
		}
		
		if (player.field_7512 instanceof final BackpackMenu menu) {
			if (menu.getBackpackInventory() instanceof final BackpackInventory inventory) {
				if (inventory.getStack().method_7909() instanceof final BackpackItem backpack) {
					if (backpack.canAutoPickup(stackToPickup, inventory.getStack())) {
						final class_1799 result = inventory.method_5491(stackToPickup);
						if (result.method_7947() != stackToPickup.method_7947()) {
							inventory.writeItemStack();
						}
						stackToPickup = result;
						if (stackToPickup.method_7960()) {
							return stackToPickup;
						}
					}
				}
				
				stackToPickup = insertInBackpack(player, inventory.getStack(), stackToPickup);
				if (stackToPickup.method_7960()) {
					return stackToPickup;
				}
			}
		}
		
		for (final Function<class_3222, class_1799> function : INTEGRATION_BACKPACKS) {
			final class_1799 stack = function.apply(player);
			if (!stack.method_7960()) {
				stackToPickup = insertInBackpack(player, stack, stackToPickup);
				if (stackToPickup.method_7960()) {
					return stackToPickup;
				}
			}
		}
		
		final class_1661 playerInventory = player.method_31548();
		for (int index = 0; index < playerInventory.method_5439(); index++) {
			final class_1799 stack = playerInventory.method_5438(index);
			
			stackToPickup = insertInBackpack(player, stack, stackToPickup);
			if (stackToPickup.method_7960()) {
				return stackToPickup;
			}
		}
		return stackToPickup;
	}
	
	private static class_1799 insertInBackpack(class_3222 player, class_1799 stack, class_1799 stackToPickup) {
		final class_1792 item = stack.method_7909();
		
		if (item instanceof final Backpack backpack) {
			if (backpack.canAutoPickup(stackToPickup, stack)) {
				final class_1277 inventory = backpack.getInventory(player, stack);
				final class_1799 result = inventory.method_5491(stackToPickup);
				if (result.method_7947() != stackToPickup.method_7947()) {
					backpack.saveInventory(inventory, stack);
				}
				stackToPickup = result;
			}
		}
		return stackToPickup;
	}
	
}
