package info.u_team.useful_backpacks.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ItemFilterComponent {
	
	public static final Codec<ItemFilterComponent> CODEC = RecordCodecBuilder.create(instance -> {
		return instance.group( //
				Codec.BOOL.orElse(true).fieldOf("strict").forGetter(component -> component.strict), //
				class_1799.field_49266.fieldOf("stack").forGetter(component -> component.stack)) //
				.apply(instance, ItemFilterComponent::new);
	});
	
	public static final class_9139<class_9129, ItemFilterComponent> STREAM_CODEC = class_9139.method_56435( //
			class_9135.field_48547, component -> component.strict, //
			class_1799.field_49268, component -> component.stack, //
			ItemFilterComponent::new);
	
	public static final ItemFilterComponent EMPTY = new ItemFilterComponent(false, class_1799.field_8037);
	
	private final boolean strict;
	private final class_1799 stack;
	
	private ItemFilterComponent(boolean strict, class_1799 stack) {
		this.strict = strict;
		this.stack = stack;
	}
	
	public static ItemFilterComponent of(boolean strict, class_1799 stack) {
		return new ItemFilterComponent(strict, stack.method_46651(1));
	}
	
	public boolean isStrict() {
		return strict;
	}
	
	public boolean isPresent() {
		return !stack.method_7960();
	}
	
	public class_1799 getStack() {
		return stack.method_7972();
	}
	
	@Override
	public int hashCode() {
		int hash = 7;
		hash = 31 * hash + Boolean.hashCode(strict);
		hash = 31 * hash + (stack == null ? 0 : class_1799.method_57355(stack));
		return hash;
	}
	
	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		if ((object == null) || (getClass() != object.getClass())) {
			return false;
		}
		final ItemFilterComponent other = (ItemFilterComponent) object;
		return strict == other.strict && (stack == other.stack || stack != null && other.stack != null && stack.method_7960() == other.stack.method_7960() && class_1799.method_31577(stack, other.stack));
	}
	
}
