/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl.common;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.network.NetworkHandler;
import info.u_team.u_team_core.api.network.NetworkMessage;
import info.u_team.u_team_core.api.network.NetworkPayload;
import info.u_team.u_team_core.util.NetworkUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonNetworkHandler
implements NetworkHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"NetworkHandler");
    protected final class_2960 networkId;
    protected final int protocolVersion;
    protected final Map<class_8710.class_9154<?>, MessagePacketPayload<?>> messages;

    protected CommonNetworkHandler(class_2960 networkId, int protocolVersion) {
        this.networkId = networkId;
        this.protocolVersion = protocolVersion;
        this.messages = new HashMap();
    }

    public <M> NetworkMessage<M> createNetworkMessage(MessagePacketPayload<M> messagePayload) {
        return new CommonNetworkMessage<M>(messagePayload);
    }

    @Override
    public <M> NetworkMessage<M> register(String id, NetworkPayload<M> payload) {
        class_2960 messageId = this.networkId.method_48331("/" + id);
        MessagePacketPayload<M> messagePayload = new MessagePacketPayload<M>(messageId, payload);
        if (this.messages.put(messagePayload.type, messagePayload) != null) {
            throw new IllegalArgumentException("Duplicate message id " + String.valueOf(messageId));
        }
        return this.createNetworkMessage(messagePayload);
    }

    @Override
    public class_2960 getNetworkId() {
        return this.networkId;
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    protected static class CommonNetworkMessage<M>
    implements NetworkMessage<M> {
        protected final MessagePacketPayload<M> messagePayload;

        protected CommonNetworkMessage(MessagePacketPayload<M> messagePayload) {
            this.messagePayload = messagePayload;
        }

        @Override
        public class_8710 packet(M message) {
            return this.messagePayload.createCustomPacketPayload(message);
        }

        @Override
        public class_2596<?> packet(NetworkEnvironment toEnvironment, M message) {
            class_8710 payload = this.packet(message);
            return switch (toEnvironment) {
                default -> throw new MatchException(null, null);
                case NetworkEnvironment.CLIENT -> NetworkUtil.createClientBoundPacket(payload);
                case NetworkEnvironment.SERVER -> NetworkUtil.createServerBoundPacket(payload);
            };
        }

        @Override
        public void sendToPlayer(class_3222 player, M message) {
            if (this.messagePayload.canWrite(NetworkEnvironment.CLIENT)) {
                NetworkUtil.sendToPlayer(player, this.packet(NetworkEnvironment.CLIENT, message));
            }
        }

        @Override
        public void sendToConnection(class_2535 connection, M message) {
            if (this.messagePayload.canWrite(NetworkEnvironment.CLIENT)) {
                NetworkUtil.sendToConnection(connection, this.packet(NetworkEnvironment.CLIENT, message));
            }
        }

        @Override
        public void sendToServer(M message) {
            if (this.messagePayload.canWrite(NetworkEnvironment.SERVER)) {
                NetworkUtil.sendToServer(this.packet(NetworkEnvironment.SERVER, message));
            }
        }
    }

    protected static class MessagePacketPayload<M> {
        private final class_8710.class_9154<class_8710> type;
        private final class_9139<? super class_9129, class_8710> streamCodec;
        private final NetworkPayload<M> payload;

        private MessagePacketPayload(class_2960 messageId, NetworkPayload<M> payload) {
            this.payload = payload;
            this.type = new class_8710.class_9154(messageId);
            this.streamCodec = this.cast((class_9139<class_9129, class_8710>)payload.streamCodec().method_56432(x$0 -> new CustomPacketPayloadImpl(x$0), CustomPacketPayloadImpl::getMessage));
        }

        public NetworkPayload<M> payload() {
            return this.payload;
        }

        public class_8710.class_9154<class_8710> type() {
            return this.type;
        }

        public class_9139<? super class_9129, class_8710> streamCodec() {
            return this.streamCodec;
        }

        public void handle(class_8710 customPacketPayload, NetworkContext context) {
            this.handle(this.cast(customPacketPayload).getMessage(), context);
        }

        private class_8710 createCustomPacketPayload(M message) {
            return new CustomPacketPayloadImpl(message);
        }

        private boolean canWrite(NetworkEnvironment handlerEnvironment) {
            if (!this.payload.handlerEnvironment().isValid(handlerEnvironment)) {
                LOGGER.error("Failed to write message to channel {} because not handler is defined on the {} environment. Expected {} environment", new Object[]{this.type.comp_2242(), handlerEnvironment, this.payload.handlerEnvironment()});
                return false;
            }
            return true;
        }

        private void handle(M message, NetworkContext context) {
            if (message == null) {
                return;
            }
            NetworkEnvironment current = context.getEnvironment();
            if (!this.payload.handlerEnvironment().isValid(current)) {
                LOGGER.error("Message {} in channel {} cannot be handled on the {} environment. Expected {} environment", new Object[]{message.getClass(), this.type.comp_2242(), current, this.payload.handlerEnvironment()});
                return;
            }
            try {
                this.payload.handle(message, context);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to handle message {} in channel {}", new Object[]{message.getClass(), this.type.comp_2242(), ex});
            }
        }

        private class_9139<? super class_9129, class_8710> cast(class_9139<? super class_9129, ? extends class_8710> streamCodec) {
            return streamCodec;
        }

        private CustomPacketPayloadImpl cast(class_8710 customPacketPayload) {
            return (CustomPacketPayloadImpl)customPacketPayload;
        }

        private class CustomPacketPayloadImpl
        implements class_8710 {
            private final M message;

            private CustomPacketPayloadImpl(M message) {
                this.message = message;
            }

            public class_8710.class_9154<? extends class_8710> method_56479() {
                return MessagePacketPayload.this.type;
            }

            private M getMessage() {
                return this.message;
            }
        }
    }

    protected static abstract class CommonNetworkContext<M>
    implements NetworkContext {
        protected final MessagePacketPayload<M> messagePayload;

        protected CommonNetworkContext(MessagePacketPayload<M> messagePayload) {
            this.messagePayload = messagePayload;
        }

        protected abstract CompletableFuture<Void> execute(Runnable var1);

        @Override
        public final CompletableFuture<Void> executeOnMainThread(Runnable runnable) {
            return this.execute(() -> {
                try {
                    runnable.run();
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to handle synchronized message in channel {}", (Object)this.messagePayload.type().comp_2242(), (Object)ex);
                }
            });
        }
    }
}

