/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.block.BlockItemProvider;
import info.u_team.u_team_core.api.registry.BlockRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.event.SetupEvents;
import info.u_team.u_team_core.impl.FabricCommonRegister;
import info.u_team.u_team_core.impl.common.CommonBlockRegistryEntry;
import info.u_team.u_team_core.util.CastUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class FabricBlockRegister
implements BlockRegister {
    private final FabricCommonRegister<class_2248> blocks;
    private final FabricCommonRegister<class_1792> items;
    private final Map<FabricCommonRegister.FabricRegistryEntry<? extends class_2248>, FabricCommonRegister.FabricRegistryEntry<? extends class_1792>> blockToItemsMap;

    FabricBlockRegister(String modid) {
        this.blocks = new FabricCommonRegister(class_7924.field_41254, modid);
        this.items = new FabricCommonRegister(class_7924.field_41197, modid);
        this.blockToItemsMap = new LinkedHashMap<FabricCommonRegister.FabricRegistryEntry<? extends class_2248>, FabricCommonRegister.FabricRegistryEntry<? extends class_1792>>();
    }

    public <B extends class_2248, I extends class_1792> FabricBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> supplier) {
        RegistryEntry block = this.blocks.register(name, supplier);
        class_2960 id = class_2960.method_60655((String)this.items.getModid(), (String)name);
        class_5321 key = (class_5321)CastUtil.uncheckedCast(class_5321.method_29179(this.items.getRegistryKey(), (class_2960)id));
        FabricCommonRegister.FabricRegistryEntry item = new FabricCommonRegister.FabricRegistryEntry(id, key);
        this.blockToItemsMap.put((FabricCommonRegister.FabricRegistryEntry<? extends class_2248>)block, item);
        return new FabricBlockRegistryEntry(block, item);
    }

    public <B extends class_2248, I extends class_1792> FabricBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Function<class_2248, ? extends I> itemFunction) {
        return this.register(name, (Supplier)blockSupplier, () -> (class_1792)itemFunction.apply((class_2248)class_7923.field_41175.method_10223(class_2960.method_60655((String)this.blocks.getModid(), (String)name))));
    }

    public <B extends class_2248, I extends class_1792> FabricBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Supplier<? extends I> itemSupplier) {
        RegistryEntry block = this.blocks.register(name, blockSupplier);
        RegistryEntry item = this.items.register(name, itemSupplier);
        return new FabricBlockRegistryEntry(block, item);
    }

    public <B extends class_2248> FabricCommonRegister.FabricRegistryEntry<B> registerBlock(String name, Supplier<? extends B> supplier) {
        return this.blocks.register(name, supplier);
    }

    @Override
    public void register() {
        this.blocks.register();
        this.items.register();
        SetupEvents.REGISTER.register(this::registerItems);
    }

    private void registerItems(class_5321<? extends class_2378<?>> eventKey) {
        if (eventKey.equals((Object)class_7924.field_41197)) {
            this.blockToItemsMap.forEach((? super K blockEntry, ? super V itemEntry) -> {
                BlockItemProvider blockItemProvider;
                class_1792 blockItem;
                class_2248 block = (class_2248)blockEntry.get();
                if (block instanceof BlockItemProvider && (blockItem = (blockItemProvider = (BlockItemProvider)block).blockItem()) != null) {
                    class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)itemEntry.getId(), (Object)blockItem);
                    itemEntry.updateReference((class_2378)CastUtil.uncheckedCast(class_7923.field_41178));
                }
            });
        }
    }

    @Override
    public String getModid() {
        return this.blocks.getModid();
    }

    @Override
    public Iterator<RegistryEntry<class_2248>> iterator() {
        return this.blocks.iterator();
    }

    @Override
    public Iterable<class_2248> blockIterable() {
        return this.blocks.entryIterable();
    }

    @Override
    public Iterable<class_1792> itemIterable() {
        return () -> this.blocks.getEntries().stream().map(block -> {
            class_1792 item = ((class_2248)block.get()).method_8389();
            if (item != null && item != class_1802.field_8162) {
                return Optional.of(item);
            }
            return Optional.empty();
        }).flatMap(Optional::stream).iterator();
    }

    public FabricCommonRegister<class_2248> getBlockRegister() {
        return this.blocks;
    }

    public FabricCommonRegister<class_1792> getItemRegister() {
        return this.items;
    }

    public static class FabricBlockRegistryEntry<B extends class_2248, I extends class_1792>
    extends CommonBlockRegistryEntry<B, I, FabricCommonRegister.FabricRegistryEntry<B>, FabricCommonRegister.FabricRegistryEntry<I>> {
        FabricBlockRegistryEntry(FabricCommonRegister.FabricRegistryEntry<B> block, FabricCommonRegister.FabricRegistryEntry<I> item) {
            super(block, item);
        }
    }

    public static class Factory
    implements BlockRegister.Factory {
        @Override
        public BlockRegister create(String modid) {
            return new FabricBlockRegister(modid);
        }
    }
}

