package info.u_team.u_team_core.impl;

import java.util.Map.Entry;
import java.util.function.Supplier;

import info.u_team.u_team_core.api.registry.client.KeyMappingRegister;
import info.u_team.u_team_core.impl.common.CommonKeyMappingRegister;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;

public class FabricKeyMappingRegister extends CommonKeyMappingRegister {
	
	FabricKeyMappingRegister() {
	}
	
	@Override
	public void register() {
		for (final Entry<KeyMappingLazyEntry, Supplier<class_304>> entry : entries.entrySet()) {
			final KeyMappingLazyEntry registryEntry = entry.getKey();
			final class_304 keyMapping = entry.getValue().get();
			KeyBindingHelper.registerKeyBinding(keyMapping);
			updateReference(registryEntry, keyMapping);
		}
	}
	
	public static class Factory implements KeyMappingRegister.Factory {
		
		@Override
		public KeyMappingRegister create() {
			return new FabricKeyMappingRegister();
		}
	}
}
