package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.registry.client.EntityRendererRegister;
import info.u_team.u_team_core.event.SetupEvents;
import info.u_team.u_team_core.impl.common.CommonEntityRendererRegister;
import info.u_team.u_team_core.util.CastUtil;
import net.minecraft.class_5616;
import net.minecraft.class_5619;

public class FabricEntityRendererRegister extends CommonEntityRendererRegister {
	
	@Override
	public void register() {
		SetupEvents.COMMON_SETUP.register(this::setup);
	}
	
	private void setup() {
		entityProviders.forEach((supplier, provider) -> {
			class_5619.method_32173(CastUtil.uncheckedCast(supplier.get()), provider);
		});
		blockEntityProviders.forEach((supplier, provider) -> {
			class_5616.method_32144(CastUtil.uncheckedCast(supplier.get()), provider);
		});
	}
	
	public static class Factory implements EntityRendererRegister.Factory {
		
		@Override
		public EntityRendererRegister create() {
			return new FabricEntityRendererRegister();
		}
	}
	
}
