package info.u_team.u_team_core.gui.elements;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.util.FontUtil;
import info.u_team.u_team_core.util.RGBA;

public class ScalableText implements class_4068, Scalable {
	
	protected static final Consumer<ScalableText> EMPTY_TEXT_CHANGED = renderer -> {
	};
	
	protected final class_327 font;
	
	protected Supplier<String> textSupplier;
	
	protected float x;
	protected float y;
	
	private String text;
	private int textWidth;
	
	protected RGBA color;
	protected boolean shadow;
	protected float scale;
	private float positionFactor;
	
	protected Consumer<ScalableText> textChanged;
	
	public ScalableText(class_327 font, Supplier<String> textSupplier, float x, float y) {
		this.font = font;
		this.textSupplier = textSupplier;
		this.x = x;
		this.y = y;
		textWidth = -1;
		color = RGBA.WHITE;
		scale = 1;
		positionFactor = 1;
		textChanged = EMPTY_TEXT_CHANGED;
	}
	
	public void setTextSupplier(Supplier<String> textSupplier) {
		Objects.requireNonNull(textSupplier);
		this.textSupplier = textSupplier;
	}
	
	public Supplier<String> getTextSupplier() {
		return textSupplier;
	}
	
	public float getX() {
		return x;
	}
	
	public void setX(float x) {
		this.x = x;
	}
	
	public float getY() {
		return y;
	}
	
	public void setY(float y) {
		this.y = y;
	}
	
	public RGBA getColor() {
		return color;
	}
	
	public void setColor(RGBA color) {
		this.color = color;
	}
	
	public boolean isShadow() {
		return shadow;
	}
	
	public void setShadow(boolean shadow) {
		this.shadow = shadow;
	}
	
	@Override
	public float getScale() {
		return scale;
	}
	
	@Override
	public void setScale(float scale) {
		this.scale = scale;
		positionFactor = 1 / scale;
	}
	
	public void setTextChanged(Consumer<ScalableText> textChanged) {
		this.textChanged = textChanged;
	}
	
	public float getTextWidth() {
		if (textWidth == -1) { // If text width has never been set
			setText(textSupplier.get());
		}
		return textWidth * scale;
	}
	
	protected void setText(String newText) {
		if ((newText != null && !newText.equals(text)) || (newText == null && text != null)) {
			text = newText;
			textWidth = font.method_1727(newText);
			updatedText();
		}
	}
	
	protected void updatedText() {
		textChanged.accept(this);
	}
	
	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		// Get new text and set if has changed
		setText(textSupplier.get());
		renderFont(guiGraphics, font, x, y);
	}
	
	protected void renderFont(class_332 guiGraphics, class_327 font, float x, float y) {
		final class_4587 poseStack = guiGraphics.method_51448();
		poseStack.method_22903();
		poseStack.method_22905(scale, scale, 0);
		FontUtil.drawString(guiGraphics, font, text, x * positionFactor, y * positionFactor, color.getColorARGB(), shadow);
		poseStack.method_22909();
	}
}
