package info.u_team.u_team_core.api.item;

import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public interface UItemExtension {
	
	/**
	 * Should play update animations when e.g. switching item slots or updating stacks
	 * 
	 * @param oldStack Old stack
	 * @param newStack New stack
	 * @return Return true to update
	 */
	default boolean shouldPlayUpdateAnimation(class_1799 oldStack, class_1799 newStack) {
		return !oldStack.equals(newStack);
	}
	
	/**
	 * Should the player be able to drop this item?
	 * 
	 * @param stack Stack
	 * @param player Player
	 * @return Return true to allow drops
	 */
	default boolean canBeDropped(class_1799 stack, class_1657 player) {
		return true;
	}
	
	/**
	 * Called when the item is dropped in the world as an {@link class_1542}
	 * 
	 * @param stack Stack
	 * @param entity ItemEntity that holds this stack
	 * @return Return true to skip the default tick logic, false otherwise
	 */
	default boolean updateItemEntity(class_1799 stack, class_1542 entity) {
		return false;
	}
}
