package info.u_team.u_team_test.test_multiloader.screen;

import java.text.DecimalFormat;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7919;
import org.slf4j.Logger;

import com.mojang.logging.LogUtils;

import info.u_team.u_team_core.gui.elements.ActivatableButton;
import info.u_team.u_team_core.gui.elements.CheckboxButton;
import info.u_team.u_team_core.gui.elements.ImageActivatableButton;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ImageToggleButton;
import info.u_team.u_team_core.gui.elements.ScalableEditBox;
import info.u_team.u_team_core.gui.elements.ScalableText;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.gui.elements.UEditBox;
import info.u_team.u_team_core.gui.elements.USlider;
import info.u_team.u_team_core.screen.UScreen;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_test.test_multiloader.TestMultiLoaderReference;

public class ButtonTestScreen extends UScreen {
	
	private static final Logger LOGGER = LogUtils.getLogger();
	
	private static final class_2960 TEXTURE1 = class_2960.method_60655(TestMultiLoaderReference.MODID, "textures/item/test_enderpearl_item.png");
	private static final class_2960 TEXTURE2 = class_2960.method_60655(TestMultiLoaderReference.MODID, "textures/item/test_item.png");
	
	private double mouseX;
	private double mouseY;
	
	private UEditBox textFieldWidget;
	private ScalableEditBox scalableTextFieldWidget;
	private ScalableEditBox scalableTextFieldWidget2;
	
	public ButtonTestScreen() {
		super(class_2561.method_43470("test"));
	}
	
	@Override
	protected void method_25426() {
		final DecimalFormat format = new DecimalFormat("#,###.00");
		// Mouse coord overlay
		final ScalableText mouseCoords = method_37060(new ScalableText(field_22793, () -> "Mouse X: " + format.format(mouseX) + " Y: " + format.format(mouseY), 2, 2));
		mouseCoords.setColor(new RGBA(0xFFFF00FF));
		mouseCoords.setScale(0.5F);
		
		// U Button Test
		final UButton uButton = method_37063(new UButton(10, 10, 200, 15, class_2561.method_43470("U Button")));
		uButton.setPressable(() -> LOGGER.info("Pressed U Button"));
		uButton.method_47400(class_7919.method_47407(class_2561.method_43470("U Button Tooltip")));
		
		// Scalable Button Test
		final UButton scalableButton = method_37063(new UButton(10, 30, 200, 15, class_2561.method_43470("Scalable Button")));
		scalableButton.setScale(0.75F);
		scalableButton.setTextColor(new RGBA(0x00FFFF80));
		scalableButton.method_25350(0.5F);
		scalableButton.setPressable(button -> LOGGER.info("Pressed Scalable Button"));
		scalableButton.method_47400(class_7919.method_47407(class_2561.method_43470("Scalable Button Tooltip")));
		
		// Scalable Activatable Button Test
		final ActivatableButton scalableActivatableButton = method_37063(new ActivatableButton(10, 50, 200, 15, class_2561.method_43470("Scalable Activatable Button"), false, new RGBA(0x006442FF)));
		scalableActivatableButton.setScale(0.75F);
		scalableActivatableButton.setPressable(() -> {
			LOGGER.info("Pressed Scalable Activatable Button");
			scalableActivatableButton.setActivated(!scalableActivatableButton.isActivated());
		});
		scalableActivatableButton.method_47400(class_7919.method_47407(class_2561.method_43470("Scalable Activatable Button Tooltip")));
		
		// Image Button Test
		final ImageButton imageButton = method_37063(new ImageButton(10, 70, 15, 15, TEXTURE1));
		imageButton.method_25350(0.75F);
		imageButton.setPressable(() -> {
			LOGGER.info("Pressed Image Button");
		});
		imageButton.method_47400(class_7919.method_47407(class_2561.method_43470("Image Button Tooltip")));
		
		final ImageButton imageButton2 = method_37063(new ImageButton(30, 70, 15, 15, TEXTURE1));
		imageButton2.setButtonColor(new RGBA(0xFFFF2080));
		imageButton2.setImageColor(new RGBA(0x00FFFF80));
		imageButton2.setPressable(() -> {
			LOGGER.info("Pressed Image Button 2");
		});
		imageButton2.method_47400(class_7919.method_47407(class_2561.method_43470("Image Button 2 Tooltip")));
		
		// Image Activatable Button Test
		final ImageActivatableButton imageActivatableButton = method_37063(new ImageActivatableButton(10, 90, 15, 15, TEXTURE1, false, new RGBA(0x006442FF)));
		imageActivatableButton.setPressable(() -> {
			LOGGER.info("Pressed Image Activatable Button");
			imageActivatableButton.setActivated(!imageActivatableButton.isActivated());
		});
		imageActivatableButton.method_47400(class_7919.method_47407(class_2561.method_43470("Image Activatable Button Tooltip")));
		
		// Image Toggle Button Test
		final ImageToggleButton imageToggleButton = method_37063(new ImageToggleButton(10, 110, 15, 15, TEXTURE1, TEXTURE2, false));
		imageToggleButton.setPressable(() -> {
			LOGGER.info("Pressed Image Toggle Button");
			imageToggleButton.method_25350(imageToggleButton.isToggled() ? 0.5F : 1);
		});
		imageToggleButton.method_47400(class_7919.method_47407(class_2561.method_43470("Image Toggle Button Tooltip")));
		
		final ImageToggleButton imageToggleButton2 = method_37063(new ImageToggleButton(30, 110, 15, 15, TEXTURE1, TEXTURE1, false));
		imageToggleButton2.setImageColor(new RGBA(0x00FF00FF));
		imageToggleButton2.setToggleImageColor(new RGBA(0xFF0000FF));
		imageToggleButton2.setPressable(() -> {
			LOGGER.info("Pressed Image Toggle Button 2");
		});
		imageToggleButton2.method_47400(class_7919.method_47407(class_2561.method_43470("Image Toggle Button 2 Tooltip")));
		
		// U Slider Test
		final USlider uSlider = method_37063(new USlider(10, 130, 200, 20, class_2561.method_43470("U Slider: "), class_2561.method_43470("%"), 0, 100, 20, false, true));
		uSlider.setSlider(() -> {
			LOGGER.info("Updated U Slider: " + uSlider.getValueInt());
		});
		uSlider.method_47400(class_7919.method_47407(class_2561.method_43470("U Slider Tooltip")));
		
		// Scalable Slider Test
		final USlider scalableSlider = method_37063(new USlider(10, 155, 200, 15, class_2561.method_43470("Scalable Slider: "), class_2561.method_43470("%"), 0, 100, 20, false, true));
		scalableSlider.setScale(0.5F);
		scalableSlider.setSlider(() -> {
			LOGGER.info("Updated Scalable Slider: " + scalableSlider.getValueInt());
		});
		scalableSlider.method_47400(class_7919.method_47407(class_2561.method_43470("Scalable Slider Tooltip")));
		
		final USlider scalableSlider2 = method_37063(new USlider(10, 175, 200, 30, class_2561.method_43470("Scalable Slider 2: "), class_2561.method_43470("%"), 0, 100, 20, false, true));
		scalableSlider2.setScale(1.5F);
		scalableSlider2.setSliderBackgroundColor(new RGBA(0x0000FFFF));
		scalableSlider2.setSliderColor(new RGBA(0x00FF00FF));
		scalableSlider2.setTextColor(new RGBA(0xFF0000FF));
		scalableSlider2.setDisabledTextColor(new RGBA(0xFFFF0080));
		scalableSlider2.setSlider(() -> {
			LOGGER.info("Updated Scalable Slider 2: " + scalableSlider2.getValueInt());
			if (scalableSlider2.getValueInt() == 100) {
				scalableSlider2.field_22763 = false;
			}
		});
		scalableSlider2.method_47400(class_7919.method_47407(class_2561.method_43470("Scalable Slider 2 Tooltip")));
		
		// Checkbox Button Test
		final CheckboxButton checkboxButton = method_37063(new CheckboxButton(10, 210, 15, 15, class_2561.method_43470("Checkbox Button"), false, true));
		checkboxButton.setPressable(() -> {
			LOGGER.info("Pressed Checkbox Button");
		});
		checkboxButton.method_47400(class_7919.method_47407(class_2561.method_43470("Checkbox Button Tooltip")));
		
		final CheckboxButton checkboxButton2 = method_37063(new CheckboxButton(110, 230, 15, 15, class_2561.method_43470("Checkbox Button 2"), false, true));
		checkboxButton2.method_25350(0.5F);
		checkboxButton2.setLeftSideText(true);
		checkboxButton2.setPressable(() -> {
			LOGGER.info("Pressed Checkbox Button 2");
		});
		checkboxButton2.method_47400(class_7919.method_47407(class_2561.method_43470("Checkbox Button 2 Tooltip")));
		
		// Scalable Checkbox Button Test
		final CheckboxButton scalableCheckboxButton = method_37063(new CheckboxButton(10, 250, 15, 15, class_2561.method_43470("Scalable Checkbox Button"), false, true));
		scalableCheckboxButton.setScale(0.75F);
		scalableCheckboxButton.setPressable(() -> {
			LOGGER.info("Pressed Scalable Checkbox Button");
		});
		scalableCheckboxButton.method_47400(class_7919.method_47407(class_2561.method_43470("Scalable Checkbox Button Tooltip")));
		
		final CheckboxButton scalableCheckboxButton2 = method_37063(new CheckboxButton(110, 270, 20, 20, class_2561.method_43470("Scalable Checkbox Button 2"), false, true));
		scalableCheckboxButton2.setScale(0.65F);
		scalableCheckboxButton2.setLeftSideText(true);
		scalableCheckboxButton2.setButtonColor(new RGBA(0x0000F0FF));
		scalableCheckboxButton2.setTextColor(new RGBA(0xA0A0A0FF));
		scalableCheckboxButton2.setPressable(() -> {
			LOGGER.info("Pressed Scalable Checkbox Button 2");
		});
		scalableCheckboxButton2.method_47400(class_7919.method_47407(class_2561.method_43470("Scalable Checkbox Button 2 Tooltip")));
		
		// U Text Field Test
		textFieldWidget = method_37063(new UEditBox(field_22793, 220, 110, 200, 20, textFieldWidget, class_2561.method_43470("U Text Field")));
		textFieldWidget.method_25350(0.75F);
		textFieldWidget.method_1880(500);
		textFieldWidget.method_47404(class_2561.method_43470("Hint to box"));
		textFieldWidget.method_47400(class_7919.method_47407(class_2561.method_43470("U Text Field Tooltip")));
		
		// Scalable Text Field Test
		scalableTextFieldWidget = method_37063(new ScalableEditBox(field_22793, 220, 140, 200, 30, scalableTextFieldWidget, class_2561.method_43470("Scalable Text Field"), 1.5F));
		scalableTextFieldWidget.method_1880(500);
		scalableTextFieldWidget.method_47404(class_2561.method_43470("Custom hint"));
		scalableTextFieldWidget.method_47400(class_7919.method_47407(class_2561.method_43470("Scalable Text Field Tooltip")));
		
		scalableTextFieldWidget2 = method_37063(new ScalableEditBox(field_22793, 220, 180, 200, 15, scalableTextFieldWidget2, class_2561.method_43470("Scalable Text Field 2"), 0.5F));
		scalableTextFieldWidget2.method_1880(500);
		scalableTextFieldWidget2.method_47404(class_2561.method_43470("Hint"));
		scalableTextFieldWidget2.method_47400(class_7919.method_47407(class_2561.method_43470("Scalable Text Field 2 Tooltip")));
		
		// Scaling Renderer Test
		final ScalableText scalingRenderer = method_37060(new ScalableText(field_22793, () -> "This is a test for the scaling text renderer", 220, 10));
		scalingRenderer.setColor(new RGBA(0xFF00FF40));
		scalingRenderer.setScale(1.5F);
		
		// Scrolling Renderer Test
		final ScrollingText scrollingRenderer = method_37060(new ScrollingText(field_22793, () -> "This is a test for the scrolling text renderer that should be really long to test the scrolling", 220, 25));
		scrollingRenderer.setColor(new RGBA(0x00FFFFFF));
		scrollingRenderer.setWidth(200);
		scrollingRenderer.setScale(2F);
		
		// Scrolling List Test
		method_37063(new BasicTestList(220, 210, 200, 90));
	}
	
	@Override
	public void method_16014(double mouseX, double mouseY) {
		super.method_16014(mouseX, mouseY);
		this.mouseX = mouseX;
		this.mouseY = mouseY;
	}
}
