package info.u_team.u_team_test.test_multiloader.init;

import info.u_team.u_team_core.api.registry.CommonRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.item.SpawnEggCreator;
import info.u_team.u_team_core.item.armor.ArmorSet;
import info.u_team.u_team_core.item.armor.ArmorSetCreator;
import info.u_team.u_team_core.item.tier.TierSet;
import info.u_team.u_team_core.item.tier.TierSetCreator;
import info.u_team.u_team_test.test_multiloader.TestMultiLoaderReference;
import info.u_team.u_team_test.test_multiloader.item.TestDimensionTeleportItem;
import info.u_team.u_team_test.test_multiloader.item.TestEnderPearlItem;
import info.u_team.u_team_test.test_multiloader.item.TestFoodItem;
import info.u_team.u_team_test.test_multiloader.item.TestUseItem;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_1793;
import net.minecraft.class_1826;
import net.minecraft.class_7924;

public class TestMultiLoaderItems {
	
	public static final CommonRegister<class_1792> ITEMS = CommonRegister.create(class_7924.field_41197, TestMultiLoaderReference.MODID);
	
	public static final RegistryEntry<class_1792> TEST = ITEMS.register("test_item", () -> new class_1792(new class_1793()));
	
	public static final RegistryEntry<TestUseItem> TEST_USE = ITEMS.register("test_use_item", TestUseItem::new);
	public static final RegistryEntry<TestFoodItem> TEST_FOOD = ITEMS.register("test_food_item", TestFoodItem::new);
	public static final RegistryEntry<TestDimensionTeleportItem> TEST_DIMENSION_TELEPORT = ITEMS.register("test_dimension_teleport_item", TestDimensionTeleportItem::new);
	
	public static final RegistryEntry<TestEnderPearlItem> TEST_ENDERPEARL = ITEMS.register("test_enderpearl_item", TestEnderPearlItem::new);
	
	public static final RegistryEntry<class_1826> TEST_LIVING_SPAWN_EGG = ITEMS.register("test_living_spawn_egg", () -> SpawnEggCreator.create(new class_1793(), TestMultiLoaderEntityTypes.TEST_LIVING, 0xFF0000, 0x00FF00));
	
	public static final TierSet TEST_TIER = TierSetCreator.create(ITEMS, "test", new class_1793().method_24359(), TestMultiLoaderTiers.TEST);
	
	public static final ArmorSet TEST_ARMOR = ArmorSetCreator.create(ITEMS, "test", new class_1793().method_24359(), () -> TestMultiLoaderArmorMaterials.TEST.getHolder(), 50);
	
	static void register() {
		ITEMS.register();
	}
	
}
