package info.u_team.u_team_core.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;

import info.u_team.u_team_core.api.Platform.Environment;
import info.u_team.u_team_core.event.SetupEvents;
import info.u_team.u_team_core.util.EnvironmentUtil;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_3730;
import net.minecraft.class_5253;
import net.minecraft.class_5712;
import net.minecraft.class_7699;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class UFabricSpawnEggItem extends class_1826 {
	
	private static final List<UFabricSpawnEggItem> TO_REGISTER = new ArrayList<>();
	private static final Map<class_1299<? extends class_1308>, UFabricSpawnEggItem> EGGS = Maps.newIdentityHashMap();
	
	private final Supplier<? extends class_1299<? extends class_1308>> entityType;
	
	public UFabricSpawnEggItem(class_1793 properties, Supplier<? extends class_1299<? extends class_1308>> entityType, int backgroundColor, int highlightColor) {
		super(null, backgroundColor, highlightColor, properties);
		field_8914.remove(null, this);
		TO_REGISTER.add(this);
		this.entityType = Suppliers.memoize(entityType::get);
	}
	
	public class_1299<? extends class_1308> getEntityType() {
		return entityType.get();
	}
	
	public class_2357 createDispenserItemBehavior() {
		return new class_2347() {
			
			@Override
			public class_1799 method_10135(class_2342 source, class_1799 stack) {
				final class_2350 direction = source.comp_1969().method_11654(class_2315.field_10918);
				final class_1299<?> entityType = ((UFabricSpawnEggItem) stack.method_7909()).method_8015(stack);
				try {
					entityType.method_5894(source.comp_1967(), stack, null, source.comp_1968().method_10093(direction), class_3730.field_16470, direction != class_2350.field_11036, false);
				} catch (final Exception ex) {
					field_34020.error("Error while dispensing spawn egg from dispenser at {}", source.comp_1968(), ex);
					return class_1799.field_8037;
				}
				stack.method_7934(1);
				source.comp_1967().method_33596(null, class_5712.field_28738, source.comp_1968());
				return stack;
			}
		};
	}
	
	public static UFabricSpawnEggItem getEgg(class_1299<?> type) {
		return EGGS.get(type);
	}
	
	public static Iterable<class_1826> getEggs() {
		return Iterables.unmodifiableIterable(EGGS.values());
	}
	
	@Override
	public class_1299<?> method_8015(class_1799 stack) {
		final class_9279 customdata = stack.method_57825(class_9334.field_49609, class_9279.field_49302);
		return !customdata.method_57458() ? customdata.method_57446(field_49273).result().orElse(getEntityType()) : getEntityType();
	}
	
	@Override
	public class_7699 method_45322() {
		return getEntityType().method_45322();
	}
	
	public static class Handler {
		
		public static void register() {
			SetupEvents.COMMON_SETUP.register(() -> {
				TO_REGISTER.forEach(spawnEgg -> {
					EGGS.put(spawnEgg.getEntityType(), spawnEgg);
					
					final class_2357 behavior = spawnEgg.createDispenserItemBehavior();
					if (behavior != null) {
						class_2315.method_10009(spawnEgg, behavior);
					}
					
					EnvironmentUtil.runWhen(Environment.CLIENT, () -> () -> Client.register(spawnEgg));
				});
			});
		}
		
		private static class Client {
			
			private static void register(UFabricSpawnEggItem spawnEgg) {
				ColorProviderRegistry.ITEM.register((stack, tintIndex) -> class_5253.class_5254.method_57174(spawnEgg.method_8016(tintIndex)), spawnEgg);
			}
		}
	}
	
	public static class Creator implements SpawnEggCreator.Creator {
		
		@Override
		public class_1826 create(class_1793 properties, Supplier<? extends class_1299<? extends class_1308>> entityType, int backgroundColor, int highlightColor) {
			return new UFabricSpawnEggItem(properties, entityType, backgroundColor, highlightColor);
		}
	}
}
