package info.u_team.u_team_core.impl.common;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_304;
import info.u_team.u_team_core.api.registry.LazyEntry;
import info.u_team.u_team_core.api.registry.client.KeyMappingRegister;

public abstract class CommonKeyMappingRegister implements KeyMappingRegister {
	
	protected final Map<KeyMappingLazyEntry, Supplier<class_304>> entries;
	
	protected CommonKeyMappingRegister() {
		entries = new LinkedHashMap<>();
	}
	
	@Override
	public LazyEntry<class_304> register(Supplier<class_304> supplier) {
		final KeyMappingLazyEntry entry = new KeyMappingLazyEntry();
		entries.put(entry, supplier);
		return entry;
	}
	
	protected void updateReference(KeyMappingLazyEntry entry, class_304 key) {
		entry.updateReference(key);
	}
	
	public static class KeyMappingLazyEntry implements LazyEntry<class_304> {
		
		private class_304 value;
		
		KeyMappingLazyEntry() {
		}
		
		void updateReference(class_304 key) {
			value = key;
		}
		
		@Override
		public class_304 get() {
			Objects.requireNonNull(value, () -> "Key mapping not present");
			return value;
		}
		
		@Override
		public boolean isPresent() {
			return value != null;
		}
	}
}
