package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.registry.client.ColorProviderRegister;
import info.u_team.u_team_core.event.SetupEvents;
import info.u_team.u_team_core.impl.common.CommonColorProviderRegister;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_310;

public class FabricColorProviderRegister extends CommonColorProviderRegister {
	
	FabricColorProviderRegister() {
	}
	
	@Override
	public void register() {
		SetupEvents.COMMON_SETUP.register(this::setup);
	}
	
	private void setup() {
		blockEntries.forEach(handler -> {
			handler.registerColor(() -> class_310.method_1551().method_1505(), (color, entries) -> {
				ColorProviderRegistry.BLOCK.register(color, entries.toArray(class_2248[]::new));
			});
		});
		itemEntries.forEach(handler -> {
			handler.registerColor(() -> class_310.method_1551().field_1760, () -> class_310.method_1551().method_1505(), (color, entries) -> {
				ColorProviderRegistry.ITEM.register(color, entries.toArray(class_1935[]::new));
			});
		});
	}
	
	public static class Factory implements ColorProviderRegister.Factory {
		
		@Override
		public ColorProviderRegister create() {
			return new FabricColorProviderRegister();
		}
	}
	
}
