package info.u_team.u_team_core.api.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import io.netty.buffer.Unpooled;

public class MessageHolder extends DataHolder {
	
	private Supplier<class_2540> send;
	private final Consumer<class_2540> receive;
	
	private boolean isTriggered;
	
	public MessageHolder(Consumer<class_2540> receive) {
		this.receive = receive;
	}
	
	@Override
	public class_2540 get() {
		return send.get();
	}
	
	@Override
	public void set(class_2540 buffer) {
		receive.accept(buffer);
	}
	
	@Override
	public boolean checkAndClearUpdateFlag() {
		if (isTriggered) {
			isTriggered = false;
			return true;
		}
		return false;
	}
	
	public void triggerMessage(Supplier<class_2540> send) {
		isTriggered = true;
		this.send = send;
	}
	
	public static class EmptyMessageHolder extends MessageHolder {
		
		public EmptyMessageHolder(Runnable receive) {
			super(packet -> receive.run());
		}
		
		public void triggerMessage() {
			triggerMessage(() -> new class_2540(Unpooled.EMPTY_BUFFER));
		}
		
	}
}
