package info.u_team.u_team_core.api.registry;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.class_1928;
import com.google.common.collect.Streams;

import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.ServiceUtil;

public interface GameRuleRegister extends Iterable<LazyEntry<class_1928.class_4313<?>>> {
	
	static GameRuleRegister create() {
		return Factory.INSTANCE.create();
	}
	
	default <T extends class_1928.class_4315<T>> LazyEntry<class_1928.class_4313<T>> register(String modid, String name, class_1928.class_5198 category, Supplier<? extends class_1928.class_4314<T>> type) {
		return register(new StringBuilder().append(modid).append(":").append(name).toString(), category, type);
	}
	
	<T extends class_1928.class_4315<T>> LazyEntry<class_1928.class_4313<T>> register(String name, class_1928.class_5198 category, Supplier<? extends class_1928.class_4314<T>> type);
	
	void register();
	
	Collection<LazyEntry<class_1928.class_4313<?>>> getEntries();
	
	@Override
	default Iterator<LazyEntry<class_1928.class_4313<?>>> iterator() {
		return getEntries().iterator();
	}
	
	default Iterable<class_1928.class_4313<?>> entryIterable() {
		return () -> CastUtil.uncheckedCast(Streams.stream(this).map(LazyEntry::get).iterator());
	}
	
	interface Factory {
		
		Factory INSTANCE = ServiceUtil.loadOne(Factory.class);
		
		GameRuleRegister create();
	}
	
}
