package info.u_team.u_team_core.api.block;

import info.u_team.u_team_core.menu.UBlockEntityContainerMenu;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_3908;

/**
 * Implement this in you block entity when it should synchronize initial values when a player opens the container
 *
 * @author HyCraftHD
 */
public interface MenuSyncedBlockEntity extends class_3908 {
	
	/**
	 * Collect data here that should be sent to the client side when the menu will be opened. The method will only be called
	 * automatically if
	 * {@link EntityBlockProvider#openMenu(net.minecraft.class_1937, net.minecraft.class_2338, class_1657, boolean)}
	 * is used for opening the menu. <br>
	 * The data will be received on the client side in this method:
	 * {@link #handleInitialMenuDataFromServer(class_2540)}
	 *
	 * @param byteBuf Data to be send to the client
	 */
	void sendInitialMenuDataToClient(class_2540 byteBuf);
	
	/**
	 * The collected data for the initial menu opening is received here on the client side. The method will only be called
	 * if {@link UBlockEntityContainerMenu} is used as a base class for the menu or an equivalent implementation is used.
	 * <br>
	 * The data is sent from the server side here: {@link #sendInitialMenuDataToClient(class_2540)}
	 *
	 * @param byteBuf Received data from the server
	 */
	void handleInitialMenuDataFromServer(class_2540 byteBuf);
	
	/**
	 * Used to create a menu on the server side
	 */
	@Override
	class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player);
	
}
