package info.u_team.u_team_test.test_multiloader.blockentity;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

import com.mojang.logging.LogUtils;

import info.u_team.u_team_core.blockentity.UBlockEntity;
import info.u_team.u_team_test.test_multiloader.init.TestMultiLoaderBlockEntityTypes;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public class TestSyncBlockEntity extends UBlockEntity {
	
	private static final Logger LOGGER = LogUtils.getLogger();
	
	private int counter;
	
	public TestSyncBlockEntity(class_2338 pos, class_2680 state) {
		super(TestMultiLoaderBlockEntityTypes.TEST_SYNC.get(), pos, state);
	}
	
	public void triggerCounter() {
		counter++;
		method_5431();
		sendChangesToClient();
	}
	
	public int getCounter() {
		return counter;
	}
	
	@Override
	public void saveNBT(class_2487 tag, class_7225.class_7874 registries) {
		tag.method_10569("counter", counter);
	}
	
	@Override
	public void loadNBT(class_2487 tag, class_7225.class_7874 registries) {
		counter = tag.method_10550("counter");
	}
	
	@Override
	public void sendChunkLoadData(class_2487 tag, class_7225.class_7874 registries) {
		tag.method_10569("chunk-val", counter);
		tag.method_10582("info", "Chunk load data");
		
		logMethod(tag);
	}
	
	@Override
	public void handleChunkLoadData(class_2487 tag, class_7225.class_7874 registries) {
		counter = tag.method_10550("chunk-val");
		
		logMethod(tag);
	}
	
	@Override
	public void sendUpdateStateData(class_2487 tag, class_7225.class_7874 registries) {
		tag.method_10569("update-val", counter);
		tag.method_10582("info", "Update data");
		
		logMethod(tag);
	}
	
	@Override
	public void handleUpdateStateData(class_2487 tag, class_7225.class_7874 registries) {
		counter = tag.method_10550("update-val");
		
		logMethod(tag);
	}
	
	private void logMethod(Object data) {
		final String marker = StringUtils.repeat('#', 70);
		final String methodName = StackWalker.getInstance().walk(frames -> frames.skip(1).findFirst().map(StackWalker.StackFrame::getMethodName)).get();
		final String side = method_11002() ? (field_11863.method_8608() ? "client" : "server") : "unknown";
		
		LOGGER.info(marker);
		LOGGER.info("# Method '{}' was called", methodName);
		LOGGER.info("# Side is '{}'", side);
		if (data != null) {
			LOGGER.info("# Data is '{}'", data.toString());
		}
		LOGGER.info(marker);
	}
}
