package info.u_team.u_team_core.util;

import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import info.u_team.u_team_core.intern.init.UCoreNetwork;
import info.u_team.u_team_core.intern.init.network.OpenMenuScreenMessage;
import io.netty.buffer.Unpooled;

public class MenuUtil {
	
	public static OptionalInt openMenu(class_3222 player, class_3908 menuProvider, Consumer<class_2540> data, boolean sendClosePacket) {
		if (player.field_7512 != player.field_7498) {
			if (sendClosePacket) {
				player.method_7346();
			} else {
				player.method_14247();
			}
		}
		player.method_14237();
		
		final class_1703 menu = menuProvider.createMenu(player.field_13986, player.method_31548(), player);
		if (menu == null) {
			if (player.method_7325()) {
				player.method_7353(class_2561.method_43471("container.spectatorCantOpen").method_27692(class_124.field_1061), true);
			}
			return OptionalInt.empty();
		}
		
		final class_2540 extraData = new class_2540(Unpooled.buffer());
		data.accept(extraData);
		extraData.readerIndex(0);
		UCoreNetwork.NETWORK.sendToPlayer(player, new OpenMenuScreenMessage(menu.field_7763, menu.method_17358(), menuProvider.method_5476(), extraData));
		
		player.method_14235(menu);
		player.field_7512 = menu;
		
		Extension.INSTANCES.forEach(extension -> extension.menuOpened(player, menu));
		
		return OptionalInt.of(player.field_13986);
	}
	
	public interface Extension {
		
		List<Extension> INSTANCES = ServiceUtil.loadAll(Extension.class);
		
		void menuOpened(class_3222 player, class_1703 menu);
	}
}
