package info.u_team.u_team_core.screen;

import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.RenderTickable;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;

public class UContainerMenuScreen<T extends class_1703> extends FluidContainerMenuScreen<T> implements PerspectiveRenderable, TooltipRenderable {
	
	protected static final RGBA DEFAULT_TEXT_COLOR = new RGBA(0x404040FF);
	
	protected class_2960 background;
	protected int backgroundWidth, backgroundHeight;
	protected RGBA backgroundColor;
	
	protected boolean drawTitleText;
	protected boolean drawInventoryText;
	protected RGBA textColor;
	
	public UContainerMenuScreen(T menu, class_1661 playerInventory, class_2561 title, class_2960 background, int imageWidth, int imageHeight) {
		this(menu, playerInventory, title, background);
		setImageDimensions(imageWidth, imageHeight);
	}
	
	public UContainerMenuScreen(T menu, class_1661 playerInventory, class_2561 title, class_2960 background) {
		super(menu, playerInventory, title);
		this.background = background;
		backgroundWidth = 256;
		backgroundHeight = 256;
		backgroundColor = RGBA.WHITE;
		drawTitleText = true;
		drawInventoryText = true;
		textColor = DEFAULT_TEXT_COLOR;
	}
	
	protected void setBackground(class_2960 background) {
		this.background = background;
	}
	
	protected void setBackgroundDimensions(int size) {
		setBackgroundDimensions(size, size);
	}
	
	protected void setBackgroundDimensions(int backgroundWidth, int backgroundHeight) {
		this.backgroundWidth = backgroundWidth;
		this.backgroundHeight = backgroundHeight;
	}
	
	protected void setImageDimensions(int imageWidth, int imageHeight) {
		this.field_2792 = imageWidth;
		this.field_2779 = imageHeight;
		setDefaultTextLocation();
	}
	
	protected void setDrawText(boolean drawTitleText, boolean drawInventoryText) {
		this.drawTitleText = drawTitleText;
		this.drawInventoryText = drawInventoryText;
	}
	
	protected void setDefaultTextLocation() {
		setTextLocation(8, 6, 8, field_2779 - 94);
	}
	
	protected void setTextLocation(int titleLabelX, int titleLabelY, int inventoryLabelX, int inventoryLabelY) {
		this.field_25267 = titleLabelX;
		this.field_25268 = titleLabelY;
		this.field_25269 = inventoryLabelX;
		this.field_25270 = inventoryLabelY;
	}
	
	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		renderBackground(guiGraphics, mouseX, mouseY, partialTick);
		super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
		renderForeground(guiGraphics, mouseX, mouseY, partialTick);
		renderTooltip(guiGraphics, mouseX, mouseY, partialTick);
	}
	
	@Override
	public void renderBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		method_25420(guiGraphics);
	}
	
	@Override
	public void renderForeground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
	}
	
	@Override
	public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		method_2380(guiGraphics, mouseX, mouseY);
	}
	
	@Override
	protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
		super.method_2388(guiGraphics, mouseX, mouseY);
		if (drawTitleText) {
			guiGraphics.method_51439(field_22793, field_22785, field_25267, field_25268, textColor.getColorARGB(), false);
		}
		if (drawInventoryText) {
			guiGraphics.method_51439(field_22793, field_29347, field_25269, field_25270, textColor.getColorARGB(), false);
		}
	}
	
	@Override
	protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
		RenderUtil.drawTexturedQuad(guiGraphics.method_51448(), field_2776, field_2800, field_2792, field_2779, field_2792, field_2779, 0, 0, backgroundWidth, backgroundHeight, 0, background, backgroundColor);
	}
	
	@Override
	public void method_37432() {
		for (final class_364 listener : method_25396()) {
			if (listener instanceof final RenderTickable tickable) {
				tickable.renderTick();
			}
		}
		if (field_2797 instanceof final UContainerMenu uMenu) {
			uMenu.broadcastChangesToServer();
		}
	}
	
	@Override
	public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
		final class_364 focused = method_25399();
		if (focused != null && method_25397() && button == 0) {
			focused.method_25403(mouseX, mouseY, button, dragX, dragY);
		}
		return super.method_25403(mouseX, mouseY, button, dragX, dragY);
	}
}
