package info.u_team.u_team_core.recipeserializer;

import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7710;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public abstract class UShapedRecipeSerializer<T extends class_1869> implements class_1865<T> {
	
	public static class_2371<class_1856> dissolvePattern(String[] pattern, Map<String, class_1856> keys, int width, int height) {
		return class_1869.method_8148(pattern, keys, width, height);
	}
	
	public static String[] shrink(String... shrink) {
		return class_1869.method_8146(shrink);
	}
	
	public static String[] patternFromJson(JsonArray json) {
		return class_1869.method_8145(json);
	}
	
	public static Map<String, class_1856> keyFromJson(JsonObject json) {
		return class_1869.method_8157(json);
	}
	
	public static class_1799 itemStackFromJson(JsonObject json) {
		return class_1869.method_35228(json);
	}
	
	public static class_1792 itemFromJson(JsonObject json) {
		return class_1869.method_8155(json);
	}
	
	@Override
	public T method_8121(class_2960 location, JsonObject json) {
		final String[] pattern = patternFromJson(class_3518.method_15261(json, "pattern"));
		final int recipeWidth = pattern[0].length();
		final int recipeHeight = pattern.length;
		final String group = class_3518.method_15253(json, "group", "");
		@SuppressWarnings("deprecation")
		final class_7710 category = class_7710.field_40252.method_47920(class_3518.method_15253(json, "category", null), class_7710.field_40251);
		final class_2371<class_1856> ingredients = dissolvePattern(pattern, keyFromJson(class_3518.method_15296(json, "key")), recipeWidth, recipeHeight);
		final class_1799 output = class_1869.method_35228(class_3518.method_15296(json, "result"));
		final boolean showNotification = class_3518.method_15258(json, "show_notification", true);
		return createRecipe(location, group, category, recipeWidth, recipeHeight, ingredients, output, showNotification);
	}
	
	@Override
	public T method_8122(class_2960 location, class_2540 buffer) {
		final int recipeWidth = buffer.method_10816();
		final int recipeHeight = buffer.method_10816();
		final String group = buffer.method_19772();
		final class_7710 category = buffer.method_10818(class_7710.class);
		final class_2371<class_1856> ingredients = class_2371.method_10213(recipeWidth * recipeHeight, class_1856.field_9017);
		for (int k = 0; k < ingredients.size(); ++k) {
			ingredients.set(k, class_1856.method_8086(buffer));
		}
		final class_1799 output = buffer.method_10819();
		final boolean showNotification = buffer.readBoolean();
		return createRecipe(location, group, category, recipeWidth, recipeHeight, ingredients, output, showNotification);
	}
	
	@Override
	public void toNetwork(class_2540 buffer, T recipe) {
		buffer.method_10804(recipe.field_9055);
		buffer.method_10804(recipe.field_9054);
		buffer.method_10814(recipe.field_9056);
		buffer.method_10817(recipe.field_40256);
		for (final class_1856 ingredient : recipe.field_9052) {
			ingredient.method_8088(buffer);
		}
		buffer.method_10793(recipe.field_9053);
		buffer.writeBoolean(recipe.field_42719);
	}
	
	protected abstract T createRecipe(class_2960 location, String group, class_7710 category, int recipeWidth, int recipeHeight, class_2371<class_1856> ingredients, class_1799 output, boolean showNotification);
	
	protected record ShapedRecipeValues(int width, int height, class_2371<class_1856> recipeItems, class_1799 result, class_2960 id, String group, class_7710 category, boolean showNotification) {
		
		public ShapedRecipeValues(class_1869 shapedRecipe) {
			this(shapedRecipe.field_9055, shapedRecipe.field_9054, shapedRecipe.field_9052, shapedRecipe.field_9053, shapedRecipe.field_9051, shapedRecipe.field_9056, shapedRecipe.field_40256, shapedRecipe.field_42719);
		}
	}
	
}
