package info.u_team.u_team_core.menu;

import info.u_team.u_team_core.util.ServiceUtil;
import net.minecraft.class_3917;

/**
 * Unstable api! <br>
 * Adds a management system for fluids in menus like items.
 *
 * @author HyCraftHD
 */
public abstract class FluidContainerMenu extends UAbstractContainerMenu {
	
	private final FluidContainerDelegator delegator = FluidContainerDelegator.Factory.INSTANCE.create(this);
	
	/**
	 * Creates a container menu. Must be implemented by a sub class to be used.
	 *
	 * @param menuType Menu type
	 * @param containerId Container id
	 */
	protected FluidContainerMenu(class_3917<?> menuType, int containerId) {
		super(menuType, containerId);
	}
	
	/**
	 * Sends all menu data to the client.
	 */
	@Override
	public void method_34252() {
		delegator.sendAllDataToRemote();
		super.method_34252();
	}
	
	/**
	 * Broadcast changed data
	 */
	@Override
	public void method_7623() {
		delegator.broadcastChanges();
		super.method_7623();
	}
	
	/**
	 * Broadcast all data
	 */
	@Override
	public void method_37420() {
		delegator.broadcastFullState();
		super.method_37420();
	}
	
	public FluidContainerDelegator getDelegator() {
		return delegator;
	}
	
	public static interface FluidContainerDelegator {
		
		void sendAllDataToRemote();
		
		void broadcastChanges();
		
		void broadcastFullState();
		
		interface Factory {
			
			Factory INSTANCE = ServiceUtil.loadOne(Factory.class);
			
			FluidContainerDelegator create(FluidContainerMenu menu);
		}
	}
}
