package info.u_team.u_team_core.item.tier;

import java.util.function.Supplier;
import net.minecraft.class_1856;
import com.google.common.base.Suppliers;

import info.u_team.u_team_core.api.item.ExtendedTier;

public class UExtendedTier implements ExtendedTier {
	
	private final float[] attackDamage;
	private final float[] attackSpeed;
	private final int level;
	private final int uses;
	private final float speed;
	private final float attackDamageBonus;
	private final int enchantmentValue;
	private final Supplier<? extends class_1856> repairIngredient;
	
	public UExtendedTier(float[] attackDamage, float[] attackSpeed, int level, int uses, float speed, float attackDamageBonus, int enchantmentValue, Supplier<? extends class_1856> repairIngredient) {
		this.attackDamage = attackDamage;
		this.attackSpeed = attackSpeed;
		this.level = level;
		this.uses = uses;
		this.speed = speed;
		this.attackDamageBonus = attackDamageBonus;
		this.enchantmentValue = enchantmentValue;
		this.repairIngredient = Suppliers.memoize(repairIngredient::get);
	}
	
	@Override
	public int method_8025() {
		return uses;
	}
	
	@Override
	public float method_8027() {
		return speed;
	}
	
	@Override
	public float method_8028() {
		return attackDamageBonus;
	}
	
	@Override
	public int method_8024() {
		return level;
	}
	
	@Override
	public int method_8026() {
		return enchantmentValue;
	}
	
	@Override
	public class_1856 method_8023() {
		return repairIngredient.get();
	}
	
	@Override
	public float getAttackDamage(Tools tools) {
		return attackDamage[tools.getIndex()];
	}
	
	@Override
	public float getAttackSpeed(Tools tools) {
		return attackSpeed[tools.getIndex()];
	}
	
}
