package info.u_team.u_team_core.intern.recipe;

import java.util.List;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import com.google.common.collect.Lists;

import info.u_team.u_team_core.api.dye.DyeableItem;
import info.u_team.u_team_core.intern.init.UCoreRecipeSerializers;

public class DyeableItemDyeRecipe extends class_1852 {
	
	public DyeableItemDyeRecipe(class_2960 location, class_7710 category) {
		super(location, category);
	}
	
	@Override
	public boolean matches(class_8566 container, class_1937 level) {
		class_1799 dyeableItem = class_1799.field_8037;
		final List<class_1799> dyeList = Lists.newArrayList();
		
		for (int index = 0; index < container.method_5439(); ++index) {
			final class_1799 slotStack = container.method_5438(index);
			if (!slotStack.method_7960()) {
				final class_1792 item = slotStack.method_7909();
				if (item instanceof DyeableItem) {
					if (!dyeableItem.method_7960()) {
						return false;
					}
					dyeableItem = slotStack;
				} else {
					if (!(item instanceof class_1769)) {
						return false;
					}
					dyeList.add(slotStack);
				}
			}
		}
		
		return !dyeableItem.method_7960() && !dyeList.isEmpty();
	}
	
	@Override
	public class_1799 assemble(class_8566 container, class_5455 registry) {
		class_1799 dyeableItem = class_1799.field_8037;
		final List<class_1769> dyeItemList = Lists.newArrayList();
		
		for (int index = 0; index < container.method_5439(); ++index) {
			final class_1799 slotStack = container.method_5438(index);
			if (!slotStack.method_7960()) {
				final class_1792 item = slotStack.method_7909();
				if (item instanceof DyeableItem) {
					if (!dyeableItem.method_7960()) {
						return class_1799.field_8037;
					}
					dyeableItem = slotStack.method_7972();
				} else {
					if (!(item instanceof class_1769)) {
						return class_1799.field_8037;
					}
					dyeItemList.add((class_1769) item);
				}
			}
		}
		
		if (!dyeableItem.method_7960() && !dyeItemList.isEmpty()) {
			return DyeableItem.colorStackDyeItem(dyeableItem, dyeItemList);
		} else {
			return class_1799.field_8037;
		}
	}
	
	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}
	
	@Override
	public class_1865<?> method_8119() {
		return UCoreRecipeSerializers.CRAFTING_SPECIAL_ITEMDYE.get();
	}
	
}
