package info.u_team.u_team_core.intern.init.network;

import java.util.Optional;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.menu.UContainerMenu;
import io.netty.buffer.Unpooled;

public record DataHolderMenuMessage(int containerId, int index, class_2540 dataHolderBuffer) {
	
	public static void encode(DataHolderMenuMessage message, class_2540 buffer) {
		buffer.writeByte(message.containerId);
		buffer.writeShort(message.index);
		buffer.method_10804(message.dataHolderBuffer.readableBytes());
		buffer.writeBytes(message.dataHolderBuffer);
		message.dataHolderBuffer.release();
	}
	
	public static DataHolderMenuMessage decode(class_2540 buffer) {
		final int containerId = buffer.readByte();
		final int index = buffer.readShort();
		final class_2540 dataHolderBuffer = new class_2540(Unpooled.wrappedBuffer(buffer.method_10795()));
		return new DataHolderMenuMessage(containerId, index, dataHolderBuffer);
	}
	
	public static class Handler {
		
		public static void handle(DataHolderMenuMessage message, NetworkContext context) {
			context.executeOnMainThread(() -> {
				updateDataHolder(context.getPlayer().field_7512, context.getEnvironment(), message);
				message.dataHolderBuffer.release();
			});
		}
		
		private static void updateDataHolder(class_1703 menuToTest, NetworkEnvironment environment, DataHolderMenuMessage message) {
			testContainerMenu(menuToTest, message.containerId).ifPresent(menu -> menu.setDataHolder(environment, message.index, message.dataHolderBuffer));
		}
		
		private static Optional<UContainerMenu> testContainerMenu(class_1703 menu, int containerId) {
			if (menu instanceof final UContainerMenu uContainer && menu.field_7763 == containerId) {
				return Optional.of(uContainer);
			}
			return Optional.empty();
		}
	}
}
