package info.u_team.u_team_core.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import info.u_team.u_team_core.api.block.BlockItemProvider;
import info.u_team.u_team_core.api.registry.BlockRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.event.SetupEvents;
import info.u_team.u_team_core.impl.FabricCommonRegister.FabricRegistryEntry;
import info.u_team.u_team_core.impl.common.CommonBlockRegistryEntry;
import info.u_team.u_team_core.util.CastUtil;

public class FabricBlockRegister implements BlockRegister {
	
	private final FabricCommonRegister<class_2248> blocks;
	private final FabricCommonRegister<class_1792> items;
	
	private final Map<FabricRegistryEntry<? extends class_2248>, FabricRegistryEntry<? extends class_1792>> blockToItemsMap;
	
	FabricBlockRegister(String modid) {
		blocks = new FabricCommonRegister<>(class_7924.field_41254, modid);
		items = new FabricCommonRegister<>(class_7924.field_41197, modid);
		blockToItemsMap = new LinkedHashMap<>();
	}
	
	@Override
	public <B extends class_2248 & BlockItemProvider, I extends class_1792> FabricBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> supplier) {
		final FabricRegistryEntry<B> block = blocks.register(name, supplier);
		
		final class_2960 id = new class_2960(items.getModid(), name);
		final class_5321<I> key = CastUtil.uncheckedCast(class_5321.method_29179(items.getRegistryKey(), id));
		final FabricRegistryEntry<I> item = new FabricRegistryEntry<>(id, key);
		
		blockToItemsMap.put(block, item);
		
		return new FabricBlockRegistryEntry<>(block, item);
	}
	
	@Override
	public <B extends class_2248, I extends class_1792> FabricBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Function<class_2248, ? extends I> itemFunction) {
		return register(name, blockSupplier, () -> itemFunction.apply(class_7923.field_41175.method_10223(new class_2960(blocks.getModid(), name))));
	}
	
	@Override
	public <B extends class_2248, I extends class_1792> FabricBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Supplier<? extends I> itemSupplier) {
		final FabricRegistryEntry<B> block = blocks.register(name, blockSupplier);
		final FabricRegistryEntry<I> item = items.register(name, itemSupplier);
		return new FabricBlockRegistryEntry<>(block, item);
	}
	
	@Override
	public <B extends class_2248> FabricRegistryEntry<B> registerBlock(String name, Supplier<? extends B> supplier) {
		return blocks.register(name, supplier);
	}
	
	@Override
	public void register() {
		blocks.register();
		items.register();
		SetupEvents.REGISTER.register(this::registerItems);
	}
	
	private void registerItems(class_5321<? extends class_2378<?>> eventKey) {
		if (eventKey.equals(class_7924.field_41197)) {
			blockToItemsMap.forEach((blockEntry, itemEntry) -> {
				final class_2248 block = blockEntry.get();
				if (block instanceof final BlockItemProvider blockItemProvider) {
					final class_1792 blockItem = blockItemProvider.blockItem();
					if (blockItem != null) {
						class_2378.method_10230(class_7923.field_41178, itemEntry.getId(), blockItem);
						itemEntry.updateReference(CastUtil.uncheckedCast(class_7923.field_41178));
					}
				}
			});
		}
	}
	
	@Override
	public String getModid() {
		return blocks.getModid();
	}
	
	@Override
	public Iterator<RegistryEntry<class_2248>> iterator() {
		return blocks.iterator();
	}
	
	@Override
	public Iterable<class_2248> blockIterable() {
		return blocks.entryIterable();
	}
	
	@Override
	public Iterable<class_1792> itemIterable() {
		return () -> blocks.getEntries().stream().map(block -> {
			final class_1792 item = block.get().method_8389();
			if (item != null && item != class_1802.field_8162) {
				return Optional.of(item);
			}
			return Optional.<class_1792> empty();
		}).flatMap(Optional::stream).iterator();
	}
	
	@Override
	public FabricCommonRegister<class_2248> getBlockRegister() {
		return blocks;
	}
	
	@Override
	public FabricCommonRegister<class_1792> getItemRegister() {
		return items;
	}
	
	public static class FabricBlockRegistryEntry<B extends class_2248, I extends class_1792> extends CommonBlockRegistryEntry<B, I, FabricRegistryEntry<B>, FabricRegistryEntry<I>> {
		
		FabricBlockRegistryEntry(FabricRegistryEntry<B> block, FabricRegistryEntry<I> item) {
			super(block, item);
		}
	}
	
	public static class Factory implements BlockRegister.Factory {
		
		@Override
		public BlockRegister create(String modid) {
			return new FabricBlockRegister(modid);
		}
	}
}
